/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.config.classic;

import com.google.auto.service.AutoService;
import com.powsybl.commons.config.EnvironmentModuleConfigRepository;
import com.powsybl.commons.config.ModuleConfigRepository;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigProvider;
import com.powsybl.commons.config.PlatformEnv;
import com.powsybl.commons.config.StackedModuleConfigRepository;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@AutoService(value={PlatformConfigProvider.class})
public class ClassicPlatformConfigProvider
implements PlatformConfigProvider {
    private static final String NAME = "classic";

    public String getName() {
        return NAME;
    }

    public static Path[] getDefaultConfigDirs(FileSystem fileSystem, String directories, String userHome, String pathSeparator) {
        Objects.requireNonNull(fileSystem);
        Objects.requireNonNull(userHome);
        Path[] configDirs = null;
        if (directories != null && !directories.isEmpty()) {
            configDirs = (Path[])Arrays.stream(directories.split(pathSeparator)).map(PlatformEnv::substitute).map(x$0 -> fileSystem.getPath((String)x$0, new String[0])).toArray(Path[]::new);
        }
        if (configDirs == null || configDirs.length == 0) {
            configDirs = new Path[]{fileSystem.getPath(userHome, ".itools")};
        }
        return configDirs;
    }

    static ModuleConfigRepository loadModuleRepository(Path[] configDirs, String configName) {
        List<ModuleConfigRepository> repositoriesFromPath = Arrays.stream(configDirs).map(configDir -> PlatformConfig.loadModuleRepository((Path)configDir, (String)configName)).toList();
        ArrayList<Object> repositories = new ArrayList<Object>();
        repositories.add(new EnvironmentModuleConfigRepository(System.getenv(), FileSystems.getDefault()));
        repositories.addAll(repositoriesFromPath);
        return new StackedModuleConfigRepository(repositories);
    }

    public PlatformConfig getPlatformConfig() {
        FileSystem fileSystem = FileSystems.getDefault();
        String directories = System.getProperty("powsybl.config.dirs", System.getProperty("itools.config.dir"));
        String configName = System.getProperty("powsybl.config.name", System.getProperty("itools.config.name", "config"));
        String userHome = System.getProperty("user.home");
        Path[] configDirs = ClassicPlatformConfigProvider.getDefaultConfigDirs(fileSystem, directories, userHome, File.pathSeparator);
        ModuleConfigRepository repository = ClassicPlatformConfigProvider.loadModuleRepository(configDirs, configName);
        return new PlatformConfig(repository, configDirs[0]);
    }
}

