/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.config.test;

import com.google.auto.service.AutoService;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.powsybl.commons.config.ModuleConfigRepository;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={PlatformConfigProvider.class})
public class TestPlatformConfigProvider
implements PlatformConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPlatformConfigProvider.class);
    private static final String NAME = "test";
    private static final String FILELIST_PATH = "filelist.txt";
    private static final FileSystem JIMFS = Jimfs.newFileSystem((Configuration)Configuration.unix());
    private static final String CONFIG_NAME = "config";
    static final String CONFIG_DIR = "unittests";

    public String getName() {
        return NAME;
    }

    public PlatformConfig getPlatformConfig() {
        Path cfgDir;
        InputStream resourceList = TestPlatformConfigProvider.class.getResourceAsStream(FILELIST_PATH);
        List resources = resourceList != null ? IOUtils.readLines((InputStream)resourceList, (Charset)StandardCharsets.UTF_8) : Collections.emptyList();
        try {
            cfgDir = Files.createDirectories(JIMFS.getPath(CONFIG_DIR, new String[0]).toAbsolutePath(), new FileAttribute[0]);
            for (String resource : resources) {
                Path dest = cfgDir.resolve(resource);
                LOGGER.info("Copying classpath resource: {} -> {}", (Object)resource, (Object)dest);
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                Files.copy(TestPlatformConfigProvider.class.getResourceAsStream(resource), dest, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to initialize test config", e);
        }
        ModuleConfigRepository repository = PlatformConfig.loadModuleRepository((Path)cfgDir, (String)CONFIG_NAME);
        return new PlatformConfig(repository, cfgDir);
    }
}

