/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.powsybl.contingency.ContingencyContextType;
import java.util.Objects;

public class ContingencyContext {
    private static final ContingencyContext ALL = new ContingencyContext(null, ContingencyContextType.ALL);
    private static final ContingencyContext NONE = new ContingencyContext(null, ContingencyContextType.NONE);
    private final String contingencyId;
    private final ContingencyContextType contextType;

    public ContingencyContext(@JsonProperty(value="contingencyId") String contingencyId, @JsonProperty(value="contextType") ContingencyContextType contingencyContextType) {
        this.contextType = Objects.requireNonNull(contingencyContextType);
        if (contingencyContextType == ContingencyContextType.SPECIFIC && contingencyId == null) {
            throw new IllegalArgumentException("Contingency ID should not be null in case of specific contingency context");
        }
        this.contingencyId = contingencyId;
    }

    public String getContingencyId() {
        return this.contingencyId;
    }

    public ContingencyContextType getContextType() {
        return this.contextType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContingencyContext that = (ContingencyContext)o;
        return Objects.equals(this.contingencyId, that.contingencyId) && this.contextType == that.contextType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contingencyId, this.contextType});
    }

    public String toString() {
        return "ContingencyContext(contingencyId='" + Objects.toString(this.contingencyId, "") + "', contextType=" + this.contextType + ")";
    }

    public static ContingencyContext create(String contingencyId, ContingencyContextType contingencyContextType) {
        Objects.requireNonNull(contingencyContextType);
        switch (contingencyContextType) {
            case ALL: {
                return ALL;
            }
            case NONE: {
                return NONE;
            }
            case SPECIFIC: {
                return ContingencyContext.specificContingency(contingencyId);
            }
        }
        throw new IllegalStateException("Unknown contingency context type: " + contingencyContextType);
    }

    public static ContingencyContext all() {
        return ALL;
    }

    public static ContingencyContext none() {
        return NONE;
    }

    public static ContingencyContext specificContingency(String contingencyId) {
        return new ContingencyContext(contingencyId, ContingencyContextType.SPECIFIC);
    }
}

