/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list;

import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyListLoader;
import com.powsybl.contingency.ContingencyListLoaderProvider;
import com.powsybl.contingency.contingency.list.DefaultContingencyList;
import com.powsybl.iidm.network.Network;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public interface ContingencyList {
    public static final String VERSION = "1.0";

    public static String getVersion() {
        return VERSION;
    }

    public String getName();

    public String getType();

    public List<Contingency> getContingencies(Network var1);

    public static ContingencyList load(Path path) {
        ContingencyList contingencyList;
        BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            String filename = path.getFileName().toString();
            contingencyList = ContingencyList.load(filename, stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)stream).close();
        return contingencyList;
    }

    public static ContingencyList load(String filename, InputStream stream) {
        try {
            ContingencyListLoader loader = ContingencyListLoaderProvider.getLoader(FilenameUtils.getExtension((String)filename));
            return loader.load(filename, stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static ContingencyList of(Contingency ... contingencies) {
        return new DefaultContingencyList(contingencies);
    }

    public static List<Contingency> getValidContingencies(List<Contingency> contingencies, Network network) {
        Objects.requireNonNull(contingencies);
        Objects.requireNonNull(network);
        return contingencies.stream().filter(c -> c.isValid(network)).collect(Collectors.toList());
    }
}

