/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.contingency.list.ContingencyList;
import com.powsybl.iidm.network.Network;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultContingencyList
implements ContingencyList {
    private final String name;
    private final List<Contingency> contingencies;

    public DefaultContingencyList(Contingency ... contingencies) {
        this("", contingencies);
    }

    public DefaultContingencyList(String name, Contingency ... contingencies) {
        this(name, (List<Contingency>)ImmutableList.copyOf((Object[])contingencies));
    }

    public DefaultContingencyList(String name, List<Contingency> contingencies) {
        this.name = Objects.requireNonNull(name);
        this.contingencies = ImmutableList.copyOf(contingencies);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "default";
    }

    public List<Contingency> getContingencies() {
        return this.contingencies;
    }

    @Override
    public List<Contingency> getContingencies(Network network) {
        return this.contingencies.stream().filter(ctg -> ctg.isValid(network)).collect(Collectors.toList());
    }
}

