/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.contingency.list.ContingencyList;
import com.powsybl.iidm.network.Network;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ListOfContingencyLists
implements ContingencyList {
    private final String name;
    private final List<ContingencyList> contingencyLists;

    public ListOfContingencyLists(String name, List<ContingencyList> contingencyLists) {
        this.name = Objects.requireNonNull(name);
        this.contingencyLists = ImmutableList.copyOf(contingencyLists);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "list";
    }

    @Override
    public List<Contingency> getContingencies(Network network) {
        return this.contingencyLists.stream().flatMap(contingencyList -> contingencyList.getContingencies(network).stream()).collect(Collectors.toList());
    }

    public List<ContingencyList> getContingencyLists() {
        return ImmutableList.copyOf(this.contingencyLists);
    }
}

