/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.criterion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.powsybl.contingency.contingency.list.criterion.Criterion;
import com.powsybl.contingency.contingency.list.criterion.SingleNominalVoltageCriterion;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Terminal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class TwoNominalVoltageCriterion
implements Criterion {
    private final SingleNominalVoltageCriterion.VoltageInterval voltageInterval1;
    private final SingleNominalVoltageCriterion.VoltageInterval voltageInterval2;
    @JsonIgnore
    private final List<SingleNominalVoltageCriterion.VoltageInterval> voltageIntervals = new ArrayList<SingleNominalVoltageCriterion.VoltageInterval>();

    public TwoNominalVoltageCriterion(SingleNominalVoltageCriterion.VoltageInterval voltageInterval1, SingleNominalVoltageCriterion.VoltageInterval voltageInterval2) {
        this.voltageInterval1 = voltageInterval1 == null ? new SingleNominalVoltageCriterion.VoltageInterval(null, null, null, null) : voltageInterval1;
        SingleNominalVoltageCriterion.VoltageInterval voltageInterval = this.voltageInterval2 = voltageInterval2 == null ? new SingleNominalVoltageCriterion.VoltageInterval(null, null, null, null) : voltageInterval2;
        if (!this.voltageInterval1.isNull()) {
            this.voltageIntervals.add(voltageInterval1);
        }
        if (!this.voltageInterval2.isNull()) {
            this.voltageIntervals.add(voltageInterval2);
        }
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.TWO_NOMINAL_VOLTAGE;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        if (type == IdentifiableType.TWO_WINDINGS_TRANSFORMER || type == IdentifiableType.LINE) {
            return this.filter(((Branch)identifiable).getTerminal1(), ((Branch)identifiable).getTerminal2());
        }
        if (type == IdentifiableType.HVDC_LINE) {
            return this.filter(((HvdcLine)identifiable).getConverterStation1().getTerminal(), ((HvdcLine)identifiable).getConverterStation2().getTerminal());
        }
        return false;
    }

    private boolean filter(Terminal terminal1, Terminal terminal2) {
        AtomicBoolean filter = new AtomicBoolean(true);
        this.voltageIntervals.forEach(voltageInterval -> {
            if (!voltageInterval.checkIsBetweenBound(terminal1.getVoltageLevel().getNominalV()) && !voltageInterval.checkIsBetweenBound(terminal2.getVoltageLevel().getNominalV())) {
                filter.set(false);
            }
        });
        return filter.get();
    }

    public SingleNominalVoltageCriterion.VoltageInterval getVoltageInterval1() {
        return this.voltageInterval1;
    }

    public SingleNominalVoltageCriterion.VoltageInterval getVoltageInterval2() {
        return this.voltageInterval2;
    }
}

