/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.identifier;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.contingency.list.identifier.NetworkElementIdentifier;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class NetworkElementIdentifierList
implements NetworkElementIdentifier {
    private final List<NetworkElementIdentifier> networkElementIdentifiers;
    private final String contingencyId;

    public List<NetworkElementIdentifier> getNetworkElementIdentifiers() {
        return this.networkElementIdentifiers;
    }

    public NetworkElementIdentifierList(List<NetworkElementIdentifier> networkElementIdentifiers) {
        this(networkElementIdentifiers, null);
    }

    public NetworkElementIdentifierList(List<NetworkElementIdentifier> networkElementIdentifiers, String contingencyId) {
        this.networkElementIdentifiers = ImmutableList.copyOf(networkElementIdentifiers);
        this.contingencyId = contingencyId;
    }

    @Override
    public Set<Identifiable<?>> filterIdentifiable(Network network) {
        LinkedHashSet identifiables = new LinkedHashSet();
        this.networkElementIdentifiers.forEach(identifiant -> identifiables.addAll(identifiant.filterIdentifiable(network)));
        return identifiables;
    }

    @Override
    public NetworkElementIdentifier.IdentifierType getType() {
        return NetworkElementIdentifier.IdentifierType.LIST;
    }

    @Override
    public Optional<String> getContingencyId() {
        return Optional.ofNullable(this.contingencyId);
    }
}

