/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.contingency.contingency.list.criterion.Criterion;
import com.powsybl.contingency.contingency.list.criterion.PropertyCriterion;
import com.powsybl.contingency.contingency.list.criterion.RegexCriterion;
import com.powsybl.contingency.contingency.list.criterion.SingleCountryCriterion;
import com.powsybl.contingency.contingency.list.criterion.SingleNominalVoltageCriterion;
import com.powsybl.contingency.contingency.list.criterion.ThreeNominalVoltageCriterion;
import com.powsybl.contingency.contingency.list.criterion.TwoCountriesCriterion;
import com.powsybl.contingency.contingency.list.criterion.TwoNominalVoltageCriterion;
import java.io.IOException;
import java.util.stream.Collectors;

public class CriterionSerializer
extends StdSerializer<Criterion> {
    public CriterionSerializer() {
        super(Criterion.class);
    }

    public void serialize(Criterion criterion, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", criterion.getType().toString());
        switch (criterion.getType()) {
            case SINGLE_COUNTRY: {
                serializerProvider.defaultSerializeField("countries", ((SingleCountryCriterion)criterion).getCountries().stream().map(Enum::toString).collect(Collectors.toList()), jsonGenerator);
                break;
            }
            case TWO_COUNTRY: {
                serializerProvider.defaultSerializeField("countries1", ((TwoCountriesCriterion)criterion).getCountries1().stream().map(Enum::toString).collect(Collectors.toList()), jsonGenerator);
                serializerProvider.defaultSerializeField("countries2", ((TwoCountriesCriterion)criterion).getCountries2().stream().map(Enum::toString).collect(Collectors.toList()), jsonGenerator);
                break;
            }
            case SINGLE_NOMINAL_VOLTAGE: {
                SingleNominalVoltageCriterion singleNominalVoltageCriterion = (SingleNominalVoltageCriterion)criterion;
                if (singleNominalVoltageCriterion.getVoltageInterval().isNull()) break;
                serializerProvider.defaultSerializeField("voltageInterval", (Object)singleNominalVoltageCriterion.getVoltageInterval(), jsonGenerator);
                break;
            }
            case TWO_NOMINAL_VOLTAGE: {
                TwoNominalVoltageCriterion twoNominalVoltageCriterion = (TwoNominalVoltageCriterion)criterion;
                if (!twoNominalVoltageCriterion.getVoltageInterval1().isNull()) {
                    serializerProvider.defaultSerializeField("voltageInterval1", (Object)((TwoNominalVoltageCriterion)criterion).getVoltageInterval1(), jsonGenerator);
                }
                if (twoNominalVoltageCriterion.getVoltageInterval2().isNull()) break;
                serializerProvider.defaultSerializeField("voltageInterval2", (Object)((TwoNominalVoltageCriterion)criterion).getVoltageInterval2(), jsonGenerator);
                break;
            }
            case THREE_NOMINAL_VOLTAGE: {
                ThreeNominalVoltageCriterion threeNominalVoltageCriterion = (ThreeNominalVoltageCriterion)criterion;
                if (!threeNominalVoltageCriterion.getVoltageInterval1().isNull()) {
                    serializerProvider.defaultSerializeField("voltageInterval1", (Object)threeNominalVoltageCriterion.getVoltageInterval1(), jsonGenerator);
                }
                if (!threeNominalVoltageCriterion.getVoltageInterval2().isNull()) {
                    serializerProvider.defaultSerializeField("voltageInterval2", (Object)threeNominalVoltageCriterion.getVoltageInterval2(), jsonGenerator);
                }
                if (threeNominalVoltageCriterion.getVoltageInterval3().isNull()) break;
                serializerProvider.defaultSerializeField("voltageInterval3", (Object)threeNominalVoltageCriterion.getVoltageInterval3(), jsonGenerator);
                break;
            }
            case PROPERTY: {
                jsonGenerator.writeStringField("propertyKey", ((PropertyCriterion)criterion).getPropertyKey());
                serializerProvider.defaultSerializeField("propertyValue", ((PropertyCriterion)criterion).getPropertyValues(), jsonGenerator);
                jsonGenerator.writeStringField("equipmentToCheck", ((PropertyCriterion)criterion).getEquipmentToCheck().toString());
                if (((PropertyCriterion)criterion).getSideToCheck() == null) break;
                jsonGenerator.writeStringField("sideToCheck", ((PropertyCriterion)criterion).getSideToCheck().toString());
                break;
            }
            case REGEX: {
                jsonGenerator.writeStringField("regex", ((RegexCriterion)criterion).getRegex());
                break;
            }
            default: {
                throw new IllegalArgumentException("type " + criterion.getType().toString() + " not known");
            }
        }
        jsonGenerator.writeEndObject();
    }
}

