/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.criterion;

import com.google.common.collect.ImmutableList;
import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.contingency.list.criterion.Criterion;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.List;
import java.util.Objects;

public class PropertyCriterion
implements Criterion {
    private final String propertyKey;
    private final List<String> propertyValues;
    private final EquipmentToCheck equipmentToCheck;
    private final SideToCheck sideToCheck;

    public PropertyCriterion(String propertyKey, List<String> propertyValues, EquipmentToCheck equipmentToCheck) {
        this(propertyKey, propertyValues, equipmentToCheck, null);
    }

    public PropertyCriterion(String propertyKey, List<String> propertyValues, EquipmentToCheck equipmentToCheck, SideToCheck sideToCheck) {
        this.propertyKey = Objects.requireNonNull(propertyKey);
        this.propertyValues = ImmutableList.copyOf(propertyValues);
        this.equipmentToCheck = Objects.requireNonNull(equipmentToCheck);
        this.sideToCheck = sideToCheck;
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.PROPERTY;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        switch (this.equipmentToCheck) {
            case SELF: {
                return identifiable.hasProperty(this.propertyKey) && this.propertyValues.contains(identifiable.getProperty(this.propertyKey));
            }
            case VOLTAGE_LEVEL: 
            case SUBSTATION: {
                return this.filterEquipement(identifiable, type);
            }
        }
        return false;
    }

    private boolean filterIdentifiable(Identifiable<?> identifiable) {
        return identifiable.hasProperty(this.propertyKey) && this.propertyValues.contains(identifiable.getProperty(this.propertyKey));
    }

    private boolean filterEquipement(Identifiable<?> identifiable, IdentifiableType type) {
        switch (type) {
            case STATIC_VAR_COMPENSATOR: 
            case SHUNT_COMPENSATOR: 
            case BUSBAR_SECTION: 
            case GENERATOR: 
            case DANGLING_LINE: 
            case LOAD: 
            case BATTERY: {
                return this.filterSubstationOrVoltageLevel(((Injection)identifiable).getTerminal().getVoltageLevel());
            }
            case SWITCH: {
                return this.filterSubstationOrVoltageLevel(((Switch)identifiable).getVoltageLevel());
            }
            case TWO_WINDINGS_TRANSFORMER: 
            case LINE: {
                return this.filterBranch(((Branch)identifiable).getTerminal1().getVoltageLevel(), ((Branch)identifiable).getTerminal2().getVoltageLevel());
            }
            case HVDC_LINE: {
                return this.filterBranch(((HvdcLine)identifiable).getConverterStation1().getTerminal().getVoltageLevel(), ((HvdcLine)identifiable).getConverterStation2().getTerminal().getVoltageLevel());
            }
            case THREE_WINDINGS_TRANSFORMER: {
                return this.filterThreeWindingsTransformer((ThreeWindingsTransformer)identifiable);
            }
        }
        throw new PowsyblException(String.format("type {} has no implementation for ContingencyElement", type));
    }

    private boolean filterBranch(VoltageLevel voltageLevel1, VoltageLevel voltageLevel2) {
        switch (this.sideToCheck) {
            case ONE: {
                return this.filterSubstationOrVoltageLevel(voltageLevel1) || this.filterSubstationOrVoltageLevel(voltageLevel2);
            }
            case BOTH: {
                return this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel2);
            }
        }
        throw new IllegalArgumentException("only ONE or BOTH sides can be checked when filtering properties on branches");
    }

    private boolean filterThreeWindingsTransformer(ThreeWindingsTransformer threeWindingsTransformer) {
        VoltageLevel voltageLevel1 = threeWindingsTransformer.getLeg1().getTerminal().getVoltageLevel();
        VoltageLevel voltageLevel2 = threeWindingsTransformer.getLeg2().getTerminal().getVoltageLevel();
        VoltageLevel voltageLevel3 = threeWindingsTransformer.getLeg3().getTerminal().getVoltageLevel();
        if (this.sideToCheck == null) {
            throw new IllegalArgumentException("enum to check side can not be null for threeWindingsTransformer to check their voltage level");
        }
        switch (this.sideToCheck) {
            case ONE: {
                return this.filterSubstationOrVoltageLevel(voltageLevel1) || this.filterSubstationOrVoltageLevel(voltageLevel2) || this.filterSubstationOrVoltageLevel(voltageLevel3);
            }
            case BOTH: {
                return this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel2) || this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel3) || this.filterSubstationOrVoltageLevel(voltageLevel2) && this.filterSubstationOrVoltageLevel(voltageLevel3);
            }
            case ALL_THREE: {
                return this.filterSubstationOrVoltageLevel(voltageLevel1) && this.filterSubstationOrVoltageLevel(voltageLevel2) && this.filterSubstationOrVoltageLevel(voltageLevel3);
            }
        }
        throw new IllegalArgumentException("enum to check side must be ONE, BOTH or ALL_THREE for threeWindingsTransformer");
    }

    private boolean filterSubstationOrVoltageLevel(VoltageLevel voltageLevel) {
        if (this.equipmentToCheck == EquipmentToCheck.VOLTAGE_LEVEL) {
            return this.filterIdentifiable((Identifiable<?>)voltageLevel);
        }
        Substation substation = voltageLevel.getNullableSubstation();
        return substation != null && this.filterIdentifiable((Identifiable<?>)substation);
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public List<String> getPropertyValues() {
        return this.propertyValues;
    }

    public EquipmentToCheck getEquipmentToCheck() {
        return this.equipmentToCheck;
    }

    public SideToCheck getSideToCheck() {
        return this.sideToCheck;
    }

    public static enum EquipmentToCheck {
        SELF,
        VOLTAGE_LEVEL,
        SUBSTATION;

    }

    public static enum SideToCheck {
        ONE,
        BOTH,
        ALL_THREE;

    }
}

