/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency;

import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.contingency.BranchContingency;
import com.powsybl.contingency.BusContingency;
import com.powsybl.contingency.BusbarSectionContingency;
import com.powsybl.contingency.ContingencyBuilder;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.contingency.DanglingLineContingency;
import com.powsybl.contingency.GeneratorContingency;
import com.powsybl.contingency.HvdcLineContingency;
import com.powsybl.contingency.LineContingency;
import com.powsybl.contingency.LoadContingency;
import com.powsybl.contingency.ShuntCompensatorContingency;
import com.powsybl.contingency.StaticVarCompensatorContingency;
import com.powsybl.contingency.ThreeWindingsTransformerContingency;
import com.powsybl.contingency.TieLineContingency;
import com.powsybl.contingency.TwoWindingsTransformerContingency;
import com.powsybl.contingency.contingency.list.ContingencyList;
import com.powsybl.iidm.modification.NetworkModification;
import com.powsybl.iidm.modification.NetworkModificationList;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Contingency
extends AbstractExtendable<Contingency> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Contingency.class);
    private final String id;
    private final List<ContingencyElement> elements;

    public Contingency(String id, ContingencyElement ... elements) {
        this(id, Arrays.asList(elements));
    }

    public Contingency(String id, List<ContingencyElement> elements) {
        this.id = Objects.requireNonNull(id);
        this.elements = new ArrayList<ContingencyElement>((Collection)Objects.requireNonNull(elements));
    }

    public String getId() {
        return this.id;
    }

    public List<ContingencyElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.elements);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Contingency) {
            Contingency other = (Contingency)((Object)obj);
            return this.id.equals(other.id) && this.elements.equals(other.elements);
        }
        return false;
    }

    public void addElement(ContingencyElement element) {
        Objects.requireNonNull(element);
        this.elements.add(element);
    }

    public void removeElement(ContingencyElement element) {
        Objects.requireNonNull(element);
        this.elements.remove(element);
    }

    public NetworkModification toModification() {
        return new NetworkModificationList(this.elements.stream().map(ContingencyElement::toModification).collect(Collectors.toList()));
    }

    public boolean isValid(Network network) {
        Objects.requireNonNull(network);
        boolean valid = true;
        block15: for (ContingencyElement element : this.elements) {
            switch (element.getType()) {
                case GENERATOR: {
                    valid = Contingency.checkGeneratorContingency(this, (GeneratorContingency)element, network);
                    continue block15;
                }
                case STATIC_VAR_COMPENSATOR: {
                    valid = Contingency.checkStaticVarCompensatorContingency(this, (StaticVarCompensatorContingency)element, network);
                    continue block15;
                }
                case SHUNT_COMPENSATOR: {
                    valid = Contingency.checkShuntCompensatorContingency(this, (ShuntCompensatorContingency)element, network);
                    continue block15;
                }
                case BRANCH: {
                    valid = Contingency.checkBranchContingency(this, (BranchContingency)element, network);
                    continue block15;
                }
                case HVDC_LINE: {
                    valid = Contingency.checkHvdcLineContingency(this, (HvdcLineContingency)element, network);
                    continue block15;
                }
                case BUSBAR_SECTION: {
                    valid = Contingency.checkBusbarSectionContingency(this, (BusbarSectionContingency)element, network);
                    continue block15;
                }
                case DANGLING_LINE: {
                    valid = Contingency.checkDanglingLineContingency(this, (DanglingLineContingency)element, network);
                    continue block15;
                }
                case LINE: {
                    valid = Contingency.checkLineContingency(this, (LineContingency)element, network);
                    continue block15;
                }
                case TWO_WINDINGS_TRANSFORMER: {
                    valid = Contingency.checkTwoWindingsTransformerContingency(this, (TwoWindingsTransformerContingency)element, network);
                    continue block15;
                }
                case THREE_WINDINGS_TRANSFORMER: {
                    valid = Contingency.checkThreeWindingsTransformerContingency(this, (ThreeWindingsTransformerContingency)element, network);
                    continue block15;
                }
                case LOAD: {
                    valid = Contingency.checkLoadContingency(this, (LoadContingency)element, network);
                    continue block15;
                }
                case BUS: {
                    valid = Contingency.checkBusContingency(this, (BusContingency)element, network);
                    continue block15;
                }
                case TIE_LINE: {
                    valid = Contingency.checkTieLineContingency(this, (TieLineContingency)element, network);
                    continue block15;
                }
            }
            throw new IllegalStateException("Unknown contingency element type " + element.getType());
        }
        if (!valid) {
            LOGGER.warn("Contingency '{}' is invalid", (Object)this.id);
        }
        return valid;
    }

    @Deprecated(since="4.0.0")
    public static List<Contingency> checkValidity(List<Contingency> contingencies, Network network) {
        return ContingencyList.getValidContingencies(contingencies, network);
    }

    private static boolean checkGeneratorContingency(Contingency contingency, GeneratorContingency element, Network network) {
        if (network.getGenerator(element.getId()) == null) {
            LOGGER.warn("Generator '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkStaticVarCompensatorContingency(Contingency contingency, StaticVarCompensatorContingency element, Network network) {
        if (network.getStaticVarCompensator(element.getId()) == null) {
            LOGGER.warn("StaticVarCompensator '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkShuntCompensatorContingency(Contingency contingency, ShuntCompensatorContingency element, Network network) {
        if (network.getShuntCompensator(element.getId()) == null) {
            LOGGER.warn("ShuntCompensator '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkBranchContingency(Contingency contingency, BranchContingency element, Network network) {
        Branch branch = network.getBranch(element.getId());
        if (branch == null || element.getVoltageLevelId() != null && !element.getVoltageLevelId().equals(branch.getTerminal1().getVoltageLevel().getId()) && !element.getVoltageLevelId().equals(branch.getTerminal2().getVoltageLevel().getId())) {
            LOGGER.warn("Branch '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkLineContingency(Contingency contingency, LineContingency element, Network network) {
        Line line = network.getLine(element.getId());
        if (line == null || element.getVoltageLevelId() != null && !element.getVoltageLevelId().equals(line.getTerminal1().getVoltageLevel().getId()) && !element.getVoltageLevelId().equals(line.getTerminal2().getVoltageLevel().getId())) {
            LOGGER.warn("Line '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkTwoWindingsTransformerContingency(Contingency contingency, TwoWindingsTransformerContingency element, Network network) {
        TwoWindingsTransformer twt = network.getTwoWindingsTransformer(element.getId());
        if (twt == null || element.getVoltageLevelId() != null && !element.getVoltageLevelId().equals(twt.getTerminal1().getVoltageLevel().getId()) && !element.getVoltageLevelId().equals(twt.getTerminal2().getVoltageLevel().getId())) {
            LOGGER.warn("TwoWindingsTransformer '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkHvdcLineContingency(Contingency contingency, HvdcLineContingency element, Network network) {
        HvdcLine hvdcLine = network.getHvdcLine(element.getId());
        if (hvdcLine == null || element.getVoltageLevelId() != null && !element.getVoltageLevelId().equals(hvdcLine.getConverterStation1().getTerminal().getVoltageLevel().getId()) && !element.getVoltageLevelId().equals(hvdcLine.getConverterStation2().getTerminal().getVoltageLevel().getId())) {
            LOGGER.warn("HVDC line '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkBusbarSectionContingency(Contingency contingency, BusbarSectionContingency element, Network network) {
        if (network.getBusbarSection(element.getId()) == null) {
            LOGGER.warn("Busbar section '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkDanglingLineContingency(Contingency contingency, DanglingLineContingency element, Network network) {
        if (network.getDanglingLine(element.getId()) == null) {
            LOGGER.warn("Dangling line '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkThreeWindingsTransformerContingency(Contingency contingency, ThreeWindingsTransformerContingency element, Network network) {
        if (network.getThreeWindingsTransformer(element.getId()) == null) {
            LOGGER.warn("ThreeWindingsTransformer '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkLoadContingency(Contingency contingency, LoadContingency element, Network network) {
        if (network.getLoad(element.getId()) == null) {
            LOGGER.warn("Load '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkBusContingency(Contingency contingency, BusContingency element, Network network) {
        if (network.getBusBreakerView().getBus(element.getId()) == null) {
            LOGGER.warn("Bus '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    private static boolean checkTieLineContingency(Contingency contingency, TieLineContingency element, Network network) {
        TieLine tieLine = network.getTieLine(element.getId());
        if (tieLine == null || element.getVoltageLevelId() != null && !element.getVoltageLevelId().equals(tieLine.getDanglingLine1().getTerminal().getVoltageLevel().getId()) && !element.getVoltageLevelId().equals(tieLine.getDanglingLine2().getTerminal().getVoltageLevel().getId())) {
            LOGGER.warn("Tie line '{}' of contingency '{}' not found", (Object)element.getId(), (Object)contingency.getId());
            return false;
        }
        return true;
    }

    public static ContingencyBuilder builder(String id) {
        return new ContingencyBuilder(id);
    }

    public static Contingency battery(String id) {
        return Contingency.builder(id).addBattery(id).build();
    }

    public static Contingency branch(String id) {
        return Contingency.builder(id).addBranch(id).build();
    }

    public static Contingency branch(String id, String voltageLevelId) {
        return Contingency.builder(id).addBranch(id, voltageLevelId).build();
    }

    public static Contingency busbarSection(String id) {
        return Contingency.builder(id).addBusbarSection(id).build();
    }

    public static Contingency generator(String id) {
        return Contingency.builder(id).addGenerator(id).build();
    }

    public static Contingency hvdcLine(String id) {
        return Contingency.builder(id).addHvdcLine(id).build();
    }

    public static Contingency hvdcLine(String id, String voltageLevelId) {
        return Contingency.builder(id).addHvdcLine(id, voltageLevelId).build();
    }

    public static Contingency line(String id) {
        return Contingency.builder(id).addLine(id).build();
    }

    public static Contingency line(String id, String voltageLevelId) {
        return Contingency.builder(id).addLine(id, voltageLevelId).build();
    }

    public static Contingency tieLine(String id) {
        return Contingency.builder(id).addTieLine(id).build();
    }

    public static Contingency tieLine(String id, String voltageLevelId) {
        return Contingency.builder(id).addTieLine(id, voltageLevelId).build();
    }

    public static Contingency shuntCompensator(String id) {
        return Contingency.builder(id).addShuntCompensator(id).build();
    }

    public static Contingency staticVarCompensator(String id) {
        return Contingency.builder(id).addStaticVarCompensator(id).build();
    }

    public static Contingency twoWindingsTransformer(String id) {
        return Contingency.builder(id).addTwoWindingsTransformer(id).build();
    }

    public static Contingency twoWindingsTransformer(String id, String voltageLevelId) {
        return Contingency.builder(id).addTwoWindingsTransformer(id, voltageLevelId).build();
    }

    public static Contingency danglingLine(String id) {
        return Contingency.builder(id).addDanglingLine(id).build();
    }

    public static Contingency threeWindingsTransformer(String id) {
        return Contingency.builder(id).addThreeWindingsTransformer(id).build();
    }

    public static Contingency load(String loadId) {
        return Contingency.builder(loadId).addLoad(loadId).build();
    }

    public static Contingency bus(String busId) {
        return Contingency.builder(busId).addBus(busId).build();
    }
}

