/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.criterion;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.contingency.list.criterion.Criterion;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.List;
import java.util.Objects;

public class SingleCountryCriterion
implements Criterion {
    private final List<Country> countries;

    public SingleCountryCriterion(List<Country> countries) {
        Objects.requireNonNull(countries);
        this.countries = ImmutableList.copyOf(countries);
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.SINGLE_COUNTRY;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        switch (type) {
            case DANGLING_LINE: 
            case GENERATOR: 
            case LOAD: 
            case SHUNT_COMPENSATOR: 
            case STATIC_VAR_COMPENSATOR: 
            case BUSBAR_SECTION: 
            case BATTERY: {
                return this.filterInjection(((Injection)identifiable).getTerminal().getVoltageLevel());
            }
            case SWITCH: {
                return this.filterInjection(((Switch)identifiable).getVoltageLevel());
            }
            case TWO_WINDINGS_TRANSFORMER: {
                return this.filterSubstation(((TwoWindingsTransformer)identifiable).getNullableSubstation());
            }
            case THREE_WINDINGS_TRANSFORMER: {
                return this.filterSubstation(((ThreeWindingsTransformer)identifiable).getNullableSubstation());
            }
        }
        return false;
    }

    public List<Country> getCountries() {
        return this.countries;
    }

    private boolean filterSubstation(Substation substation) {
        if (substation == null) {
            return false;
        }
        Country injectionCountry = substation.getCountry().orElse(null);
        if (injectionCountry == null && !this.countries.isEmpty()) {
            return false;
        }
        return this.countries.isEmpty() || this.countries.contains(injectionCountry);
    }

    private boolean filterInjection(VoltageLevel voltageLevel) {
        Substation substation = voltageLevel.getSubstation().orElse(null);
        if (substation == null) {
            return false;
        }
        Country injectionCountry = substation.getCountry().orElse(null);
        if (injectionCountry == null && !this.countries.isEmpty()) {
            return false;
        }
        return this.countries.isEmpty() || this.countries.contains(injectionCountry);
    }
}

