/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.criterion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.powsybl.contingency.contingency.list.criterion.Criterion;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;

public class SingleNominalVoltageCriterion
implements Criterion {
    private final VoltageInterval voltageInterval;

    public SingleNominalVoltageCriterion(VoltageInterval voltageInterval) {
        this.voltageInterval = Objects.requireNonNull(voltageInterval);
    }

    @Override
    @JsonIgnore
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.SINGLE_NOMINAL_VOLTAGE;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        switch (type) {
            case LINE: {
                return this.filterInjection(((Line)identifiable).getTerminal1().getVoltageLevel());
            }
            case DANGLING_LINE: 
            case GENERATOR: 
            case LOAD: 
            case BATTERY: 
            case SHUNT_COMPENSATOR: 
            case STATIC_VAR_COMPENSATOR: 
            case BUSBAR_SECTION: {
                return this.filterInjection(((Injection)identifiable).getTerminal().getVoltageLevel());
            }
            case SWITCH: {
                return this.filterInjection(((Switch)identifiable).getVoltageLevel());
            }
        }
        return false;
    }

    private boolean filterInjection(VoltageLevel voltageLevel) {
        if (voltageLevel == null) {
            return false;
        }
        double injectionNominalVoltage = voltageLevel.getNominalV();
        return this.voltageInterval.isNull() || this.voltageInterval.checkIsBetweenBound(injectionNominalVoltage);
    }

    public VoltageInterval getVoltageInterval() {
        return this.voltageInterval;
    }

    public static class VoltageInterval {
        Double nominalVoltageLowBound;
        Double nominalVoltageHighBound;
        Boolean lowClosed;
        Boolean highClosed;

        public VoltageInterval() {
        }

        public VoltageInterval(Double nominalVoltageLowBound, Double nominalVoltageHighBound, Boolean lowClosed, Boolean highClosed) {
            this.nominalVoltageLowBound = nominalVoltageLowBound;
            this.nominalVoltageHighBound = nominalVoltageHighBound;
            this.lowClosed = lowClosed;
            this.highClosed = highClosed;
        }

        @JsonIgnore
        public boolean isNull() {
            return this.nominalVoltageLowBound == null || this.nominalVoltageHighBound == null || this.lowClosed == null || this.highClosed == null;
        }

        public boolean checkIsBetweenBound(double value) {
            if (this.lowClosed.booleanValue() && this.highClosed.booleanValue()) {
                return this.nominalVoltageLowBound <= value && value <= this.nominalVoltageHighBound;
            }
            if (this.lowClosed.booleanValue()) {
                return this.nominalVoltageLowBound <= value && value < this.nominalVoltageHighBound;
            }
            if (this.highClosed.booleanValue()) {
                return this.nominalVoltageLowBound < value && value <= this.nominalVoltageHighBound;
            }
            return this.nominalVoltageLowBound < value && value < this.nominalVoltageHighBound;
        }

        public Double getNominalVoltageLowBound() {
            return this.nominalVoltageLowBound;
        }

        public Double getNominalVoltageHighBound() {
            return this.nominalVoltageHighBound;
        }

        public Boolean getLowClosed() {
            return this.lowClosed;
        }

        public Boolean getHighClosed() {
            return this.highClosed;
        }
    }
}

