/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.criterion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.powsybl.contingency.contingency.list.criterion.Criterion;
import com.powsybl.contingency.contingency.list.criterion.SingleNominalVoltageCriterion;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreeNominalVoltageCriterion
implements Criterion {
    private final SingleNominalVoltageCriterion.VoltageInterval voltageInterval1;
    private final SingleNominalVoltageCriterion.VoltageInterval voltageInterval2;
    private final SingleNominalVoltageCriterion.VoltageInterval voltageInterval3;
    @JsonIgnore
    private final List<SingleNominalVoltageCriterion.VoltageInterval> voltageIntervals = new ArrayList<SingleNominalVoltageCriterion.VoltageInterval>();

    public ThreeNominalVoltageCriterion(SingleNominalVoltageCriterion.VoltageInterval voltageInterval1, SingleNominalVoltageCriterion.VoltageInterval voltageInterval2, SingleNominalVoltageCriterion.VoltageInterval voltageInterval3) {
        this.voltageInterval1 = voltageInterval1 == null ? new SingleNominalVoltageCriterion.VoltageInterval(null, null, null, null) : voltageInterval1;
        this.voltageInterval2 = voltageInterval2 == null ? new SingleNominalVoltageCriterion.VoltageInterval(null, null, null, null) : voltageInterval2;
        SingleNominalVoltageCriterion.VoltageInterval voltageInterval = this.voltageInterval3 = voltageInterval3 == null ? new SingleNominalVoltageCriterion.VoltageInterval(null, null, null, null) : voltageInterval3;
        if (!this.voltageInterval1.isNull()) {
            this.voltageIntervals.add(voltageInterval1);
        }
        if (!this.voltageInterval2.isNull()) {
            this.voltageIntervals.add(voltageInterval2);
        }
        if (!this.voltageInterval3.isNull()) {
            this.voltageIntervals.add(voltageInterval3);
        }
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.THREE_NOMINAL_VOLTAGE;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        if (type == IdentifiableType.THREE_WINDINGS_TRANSFORMER) {
            ThreeWindingsTransformer transformer = (ThreeWindingsTransformer)identifiable;
            return this.filterThreeWindingsTransformer(transformer.getLeg1().getTerminal(), transformer.getLeg2().getTerminal(), transformer.getLeg3().getTerminal());
        }
        return false;
    }

    private boolean filterThreeWindingsTransformer(Terminal terminal1, Terminal terminal2, Terminal terminal3) {
        AtomicBoolean filter = new AtomicBoolean(true);
        this.voltageIntervals.forEach(voltageInterval -> {
            if (!(voltageInterval.checkIsBetweenBound(terminal1.getVoltageLevel().getNominalV()) || voltageInterval.checkIsBetweenBound(terminal2.getVoltageLevel().getNominalV()) || voltageInterval.checkIsBetweenBound(terminal3.getVoltageLevel().getNominalV()))) {
                filter.set(false);
            }
        });
        return filter.get();
    }

    public SingleNominalVoltageCriterion.VoltageInterval getVoltageInterval1() {
        return this.voltageInterval1;
    }

    public SingleNominalVoltageCriterion.VoltageInterval getVoltageInterval2() {
        return this.voltageInterval2;
    }

    public SingleNominalVoltageCriterion.VoltageInterval getVoltageInterval3() {
        return this.voltageInterval3;
    }
}

