/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.criterion;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.contingency.list.criterion.Criterion;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TwoCountriesCriterion
implements Criterion {
    private final List<Country> countries1;
    private final List<Country> countries2;

    public TwoCountriesCriterion(List<Country> countries) {
        this(countries, Collections.emptyList());
    }

    public TwoCountriesCriterion(List<Country> countries1, List<Country> countries2) {
        Objects.requireNonNull(countries1);
        Objects.requireNonNull(countries2);
        this.countries1 = ImmutableList.copyOf(countries1);
        this.countries2 = ImmutableList.copyOf(countries2);
    }

    @Override
    public Criterion.CriterionType getType() {
        return Criterion.CriterionType.TWO_COUNTRY;
    }

    @Override
    public boolean filter(Identifiable<?> identifiable, IdentifiableType type) {
        switch (type) {
            case LINE: {
                return this.filterBranch(((Line)identifiable).getTerminal1(), ((Line)identifiable).getTerminal2());
            }
            case HVDC_LINE: {
                return this.filterBranch(((HvdcLine)identifiable).getConverterStation1().getTerminal(), ((HvdcLine)identifiable).getConverterStation2().getTerminal());
            }
        }
        return false;
    }

    private boolean filterBranch(Terminal terminal1, Terminal terminal2) {
        Substation substation1 = terminal1.getVoltageLevel().getSubstation().orElse(null);
        Substation substation2 = terminal2.getVoltageLevel().getSubstation().orElse(null);
        if (substation1 == null || substation2 == null) {
            return false;
        }
        Country countrySide1 = substation1.getCountry().orElse(null);
        Country countrySide2 = substation2.getCountry().orElse(null);
        if (countrySide1 == null && !this.countries1.isEmpty() || countrySide2 == null && !this.countries2.isEmpty()) {
            return false;
        }
        return this.countries1.isEmpty() && this.countries2.isEmpty() || this.countries1.isEmpty() && (this.countries2.contains(countrySide2) || this.countries2.contains(countrySide1)) || this.countries2.isEmpty() && (this.countries1.contains(countrySide2) || this.countries1.contains(countrySide1)) || this.countries1.contains(countrySide1) && this.countries2.contains(countrySide2) || this.countries1.contains(countrySide2) && this.countries2.contains(countrySide1);
    }

    public List<Country> getCountries1() {
        return this.countries1;
    }

    public List<Country> getCountries2() {
        return this.countries2;
    }
}

