/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list.identifier;

import com.powsybl.contingency.contingency.list.identifier.NetworkElementIdentifier;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoltageLevelAndOrderNetworkElementIdentifier
implements NetworkElementIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(VoltageLevelAndOrderNetworkElementIdentifier.class);
    private final String voltageLevelId1;
    private final String voltageLevelId2;
    private final char order;
    private final String contingencyId;

    public VoltageLevelAndOrderNetworkElementIdentifier(String voltageLevelId1, String voltageLevelId2, char order) {
        this(voltageLevelId1, voltageLevelId2, order, null);
    }

    public VoltageLevelAndOrderNetworkElementIdentifier(String voltageLevelId1, String voltageLevelId2, char order, String contingencyId) {
        this.voltageLevelId1 = Objects.requireNonNull(voltageLevelId1);
        this.voltageLevelId2 = Objects.requireNonNull(voltageLevelId2);
        this.order = order;
        this.contingencyId = contingencyId;
    }

    @Override
    public Set<Identifiable<?>> filterIdentifiable(Network network) {
        VoltageLevel voltageLevel1 = network.getVoltageLevel(this.voltageLevelId1);
        VoltageLevel voltageLevel2 = network.getVoltageLevel(this.voltageLevelId2);
        if (voltageLevel1 == null || voltageLevel2 == null) {
            return Collections.emptySet();
        }
        List connectablesVoltageLevel2 = voltageLevel2.getConnectableStream().toList();
        List<Connectable> foundConnectables = voltageLevel1.getConnectableStream().filter(connectable -> connectable.getId().endsWith(String.valueOf(this.order))).filter(connectablesVoltageLevel2::contains).toList();
        if (foundConnectables.size() == 1) {
            return Collections.singleton((Identifiable)foundConnectables.get(0));
        }
        LOG.warn("found several connectables between voltage levels {} and {} with order {}", new Object[]{Character.valueOf(this.order), voltageLevel1.getId(), voltageLevel2.getId()});
        return Collections.emptySet();
    }

    @Override
    public NetworkElementIdentifier.IdentifierType getType() {
        return NetworkElementIdentifier.IdentifierType.VOLTAGE_LEVELS_AND_ORDER;
    }

    @Override
    public Optional<String> getContingencyId() {
        return Optional.ofNullable(this.contingencyId);
    }

    public String getVoltageLevelId1() {
        return this.voltageLevelId1;
    }

    public String getVoltageLevelId2() {
        return this.voltageLevelId2;
    }

    public int getOrder() {
        return this.order;
    }
}

