/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.contingency.contingency.list.identifier.IdBasedNetworkElementIdentifier;
import com.powsybl.contingency.contingency.list.identifier.NetworkElementIdentifier;
import com.powsybl.contingency.contingency.list.identifier.NetworkElementIdentifierList;
import com.powsybl.contingency.contingency.list.identifier.VoltageLevelAndOrderNetworkElementIdentifier;
import java.io.IOException;
import java.util.Optional;

public class IdentifierSerializer
extends StdSerializer<NetworkElementIdentifier> {
    public IdentifierSerializer() {
        super(NetworkElementIdentifier.class);
    }

    public void serialize(NetworkElementIdentifier networkElementIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", networkElementIdentifier.getType().toString());
        Optional<String> optionalContingencyId = networkElementIdentifier.getContingencyId();
        if (optionalContingencyId.isPresent()) {
            jsonGenerator.writeStringField("contingencyId", optionalContingencyId.get());
        }
        switch (networkElementIdentifier.getType()) {
            case ID_BASED: {
                jsonGenerator.writeStringField("identifier", ((IdBasedNetworkElementIdentifier)networkElementIdentifier).getIdentifier());
                break;
            }
            case LIST: {
                serializerProvider.defaultSerializeField("identifierList", ((NetworkElementIdentifierList)networkElementIdentifier).getNetworkElementIdentifiers(), jsonGenerator);
                break;
            }
            case VOLTAGE_LEVELS_AND_ORDER: {
                VoltageLevelAndOrderNetworkElementIdentifier ucteIdentifier = (VoltageLevelAndOrderNetworkElementIdentifier)networkElementIdentifier;
                jsonGenerator.writeStringField("voltageLevelId1", ucteIdentifier.getVoltageLevelId1());
                jsonGenerator.writeStringField("voltageLevelId2", ucteIdentifier.getVoltageLevelId2());
                jsonGenerator.writeStringField("order", Character.toString(ucteIdentifier.getOrder()));
            }
        }
        jsonGenerator.writeEndObject();
    }
}

