/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.contingency.contingency.list.ContingencyList;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.identifiers.NetworkElementIdentifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentifierContingencyList
implements ContingencyList {
    private static final String VERSION = "1.2";
    public static final String TYPE = "identifier";
    private final String name;
    private final List<NetworkElementIdentifier> networkElementIdentifiers;

    public IdentifierContingencyList(String name, List<NetworkElementIdentifier> networkElementIdentifiers) {
        this.name = Objects.requireNonNull(name);
        this.networkElementIdentifiers = ImmutableList.copyOf(networkElementIdentifiers);
    }

    public static String getVersion() {
        return VERSION;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public List<NetworkElementIdentifier> getIdentifiants() {
        return ImmutableList.copyOf(this.networkElementIdentifiers);
    }

    @Override
    public List<Contingency> getContingencies(Network network) {
        return this.networkElementIdentifiers.stream().filter(identifier -> !identifier.filterIdentifiable(network).isEmpty()).map(identifier -> {
            List<ContingencyElement> contingencyElements = identifier.filterIdentifiable(network).stream().map(ContingencyElement::of).collect(Collectors.toList());
            String contingencyId = identifier.getContingencyId().orElse(this.getGeneratedContingencyId(contingencyElements));
            return new Contingency(contingencyId, contingencyElements);
        }).filter(contingency -> contingency.isValid(network)).collect(Collectors.toList());
    }

    public Map<String, Set<String>> getNotFoundElements(Network network) {
        HashMap<String, Set<String>> notFoundElementsMap = new HashMap<String, Set<String>>();
        this.networkElementIdentifiers.forEach(identifier -> {
            Set notFoundElements = identifier.getNotFoundElements(network);
            if (!notFoundElements.isEmpty()) {
                String contingencyId = identifier.getContingencyId().orElse(this.getGeneratedContingencyId(identifier.filterIdentifiable(network).stream().map(ContingencyElement::of).toList()));
                notFoundElementsMap.put(contingencyId, notFoundElements);
            }
        });
        return notFoundElementsMap;
    }

    private String getGeneratedContingencyId(List<ContingencyElement> contingencyElements) {
        return "Contingency : " + contingencyElements.stream().map(ContingencyElement::getId).collect(Collectors.joining(" + "));
    }
}

