/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency;

import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.BatteryContingency;
import com.powsybl.contingency.BusContingency;
import com.powsybl.contingency.BusbarSectionContingency;
import com.powsybl.contingency.ContingencyElementType;
import com.powsybl.contingency.DanglingLineContingency;
import com.powsybl.contingency.GeneratorContingency;
import com.powsybl.contingency.HvdcLineContingency;
import com.powsybl.contingency.LineContingency;
import com.powsybl.contingency.LoadContingency;
import com.powsybl.contingency.ShuntCompensatorContingency;
import com.powsybl.contingency.StaticVarCompensatorContingency;
import com.powsybl.contingency.SwitchContingency;
import com.powsybl.contingency.ThreeWindingsTransformerContingency;
import com.powsybl.contingency.TieLineContingency;
import com.powsybl.contingency.TwoWindingsTransformerContingency;
import com.powsybl.iidm.modification.tripping.Tripping;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoWindingsTransformer;

public interface ContingencyElement {
    public String getId();

    public ContingencyElementType getType();

    public Tripping toModification();

    public static ContingencyElement of(Identifiable<?> identifiable) {
        if (identifiable instanceof Line) {
            return new LineContingency(identifiable.getId());
        }
        if (identifiable instanceof BusbarSection) {
            return new BusbarSectionContingency(identifiable.getId());
        }
        if (identifiable instanceof TwoWindingsTransformer) {
            return new TwoWindingsTransformerContingency(identifiable.getId());
        }
        if (identifiable instanceof ThreeWindingsTransformer) {
            return new ThreeWindingsTransformerContingency(identifiable.getId());
        }
        if (identifiable instanceof Generator) {
            return new GeneratorContingency(identifiable.getId());
        }
        if (identifiable instanceof Switch) {
            return new SwitchContingency(identifiable.getId());
        }
        if (identifiable instanceof DanglingLine) {
            return new DanglingLineContingency(identifiable.getId());
        }
        if (identifiable instanceof Load) {
            return new LoadContingency(identifiable.getId());
        }
        if (identifiable instanceof HvdcLine) {
            return new HvdcLineContingency(identifiable.getId());
        }
        if (identifiable instanceof ShuntCompensator) {
            return new ShuntCompensatorContingency(identifiable.getId());
        }
        if (identifiable instanceof StaticVarCompensator) {
            return new StaticVarCompensatorContingency(identifiable.getId());
        }
        if (identifiable instanceof Battery) {
            return new BatteryContingency(identifiable.getId());
        }
        if (identifiable instanceof Bus) {
            return new BusContingency(identifiable.getId());
        }
        if (identifiable instanceof TieLine) {
            return new TieLineContingency(identifiable.getId());
        }
        throw new PowsyblException(identifiable.getId() + " can not be a ContingencyElement");
    }
}

