/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency;

import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.BatteryContingency;
import com.powsybl.contingency.BranchContingency;
import com.powsybl.contingency.BusContingency;
import com.powsybl.contingency.BusbarSectionContingency;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.contingency.DanglingLineContingency;
import com.powsybl.contingency.GeneratorContingency;
import com.powsybl.contingency.HvdcLineContingency;
import com.powsybl.contingency.LineContingency;
import com.powsybl.contingency.LoadContingency;
import com.powsybl.contingency.ShuntCompensatorContingency;
import com.powsybl.contingency.StaticVarCompensatorContingency;
import com.powsybl.contingency.SwitchContingency;
import com.powsybl.contingency.ThreeWindingsTransformerContingency;
import com.powsybl.contingency.TieLineContingency;
import com.powsybl.contingency.TwoWindingsTransformerContingency;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContingencyBuilder {
    private final String id;
    private final List<ContingencyElement> elements;
    private String name;

    ContingencyBuilder(String id) {
        this.id = Objects.requireNonNull(id);
        this.elements = new ArrayList<ContingencyElement>();
    }

    public Contingency build() {
        return new Contingency(this.id, this.name, this.elements);
    }

    public ContingencyBuilder addBattery(String id) {
        this.elements.add(new BatteryContingency(id));
        return this;
    }

    public ContingencyBuilder addBranch(String id) {
        this.elements.add(new BranchContingency(id));
        return this;
    }

    public ContingencyBuilder addBranch(String id, String voltageLevelId) {
        this.elements.add(new BranchContingency(id, voltageLevelId));
        return this;
    }

    public ContingencyBuilder addBusbarSection(String id) {
        this.elements.add(new BusbarSectionContingency(id));
        return this;
    }

    public ContingencyBuilder addGenerator(String id) {
        this.elements.add(new GeneratorContingency(id));
        return this;
    }

    public ContingencyBuilder addHvdcLine(String id) {
        this.elements.add(new HvdcLineContingency(id));
        return this;
    }

    public ContingencyBuilder addHvdcLine(String id, String voltageLevel) {
        this.elements.add(new HvdcLineContingency(id, voltageLevel));
        return this;
    }

    public ContingencyBuilder addLine(String id) {
        this.elements.add(new LineContingency(id));
        return this;
    }

    public ContingencyBuilder addLine(String id, String voltageLevelId) {
        this.elements.add(new LineContingency(id, voltageLevelId));
        return this;
    }

    public ContingencyBuilder addShuntCompensator(String id) {
        this.elements.add(new ShuntCompensatorContingency(id));
        return this;
    }

    public ContingencyBuilder addStaticVarCompensator(String id) {
        this.elements.add(new StaticVarCompensatorContingency(id));
        return this;
    }

    public ContingencyBuilder addTwoWindingsTransformer(String id) {
        this.elements.add(new TwoWindingsTransformerContingency(id));
        return this;
    }

    public ContingencyBuilder addTwoWindingsTransformer(String id, String voltageLevelId) {
        this.elements.add(new TwoWindingsTransformerContingency(id, voltageLevelId));
        return this;
    }

    public ContingencyBuilder addDanglingLine(String id) {
        this.elements.add(new DanglingLineContingency(id));
        return this;
    }

    public ContingencyBuilder addThreeWindingsTransformer(String id) {
        this.elements.add(new ThreeWindingsTransformerContingency(id));
        return this;
    }

    public ContingencyBuilder addLoad(String id) {
        this.elements.add(new LoadContingency(id));
        return this;
    }

    public ContingencyBuilder addSwitch(String id) {
        this.elements.add(new SwitchContingency(id));
        return this;
    }

    public ContingencyBuilder addBus(String id) {
        this.elements.add(new BusContingency(id));
        return this;
    }

    public ContingencyBuilder addTieLine(String id) {
        this.elements.add(new TieLineContingency(id));
        return this;
    }

    public ContingencyBuilder addTieLine(String id, String voltageLevelId) {
        this.elements.add(new TieLineContingency(id, voltageLevelId));
        return this;
    }

    public ContingencyBuilder addIdentifiable(String id, Network network) {
        Identifiable identifiable = network.getIdentifiable(id);
        if (identifiable == null) {
            throw new PowsyblException(String.format("Element %s has not been found in the network", id));
        }
        return this.addIdentifiable(identifiable);
    }

    public ContingencyBuilder addIdentifiable(Identifiable<?> identifiable) {
        this.elements.add(ContingencyElement.of(identifiable));
        return this;
    }

    public ContingencyBuilder addName(String name) {
        this.name = name;
        return this;
    }
}

