/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency;

import com.powsybl.contingency.ContingencyElement;
import com.powsybl.contingency.ContingencyElementType;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SidedContingencyElement
extends ContingencyElement {
    public static final Logger LOGGER = LoggerFactory.getLogger(SidedContingencyElement.class);

    public String getVoltageLevelId();

    public static TwoSides getContingencySide(Network network, SidedContingencyElement element) {
        String voltageLevelId = element.getVoltageLevelId();
        if (voltageLevelId != null) {
            Function<TwoSides, Terminal> terminalSupplier = SidedContingencyElement.getTerminalSupplier(network, element);
            if (terminalSupplier != null) {
                if (voltageLevelId.equals(terminalSupplier.apply(TwoSides.ONE).getVoltageLevel().getId())) {
                    return TwoSides.ONE;
                }
                if (voltageLevelId.equals(terminalSupplier.apply(TwoSides.TWO).getVoltageLevel().getId())) {
                    return TwoSides.TWO;
                }
                LOGGER.warn("Voltage id '{}' of contingency '{}' not found", (Object)voltageLevelId, (Object)element.getId());
            } else {
                LOGGER.warn("Id of contingency '{}' not found", (Object)element.getId());
            }
        }
        return null;
    }

    private static Function<TwoSides, Terminal> getTerminalSupplier(Network network, SidedContingencyElement element) {
        return switch (element.getType()) {
            case ContingencyElementType.BRANCH -> SidedContingencyElement.getBranchTerminalSupplier(network, element.getId());
            case ContingencyElementType.HVDC_LINE -> SidedContingencyElement.getHvdcLineTerminalSupplier(network, element.getId());
            case ContingencyElementType.LINE -> SidedContingencyElement.getLineTerminalSupplier(network, element.getId());
            case ContingencyElementType.TIE_LINE -> SidedContingencyElement.getTieLineTerminalSupplier(network, element.getId());
            case ContingencyElementType.TWO_WINDINGS_TRANSFORMER -> SidedContingencyElement.getTransformerTerminalSupplier(network, element.getId());
            default -> null;
        };
    }

    private static Function<TwoSides, Terminal> getBranchTerminalSupplier(Network network, String id) {
        Branch eq = network.getBranch(id);
        return eq != null ? arg_0 -> ((Branch)eq).getTerminal(arg_0) : null;
    }

    private static Function<TwoSides, Terminal> getLineTerminalSupplier(Network network, String id) {
        Line eq = network.getLine(id);
        return eq != null ? arg_0 -> ((Line)eq).getTerminal(arg_0) : null;
    }

    private static Function<TwoSides, Terminal> getTieLineTerminalSupplier(Network network, String id) {
        TieLine eq = network.getTieLine(id);
        return eq != null ? arg_0 -> ((TieLine)eq).getTerminal(arg_0) : null;
    }

    private static Function<TwoSides, Terminal> getTransformerTerminalSupplier(Network network, String id) {
        TwoWindingsTransformer eq = network.getTwoWindingsTransformer(id);
        return eq != null ? arg_0 -> ((TwoWindingsTransformer)eq).getTerminal(arg_0) : null;
    }

    private static Function<TwoSides, Terminal> getHvdcLineTerminalSupplier(Network network, String id) {
        HvdcLine eq = network.getHvdcLine(id);
        return eq != null ? s -> eq.getConverterStation(s).getTerminal() : null;
    }
}

