/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.contingency.contingency.list;

import com.google.common.collect.ImmutableList;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyElementFactory;
import com.powsybl.contingency.contingency.list.ContingencyList;
import com.powsybl.iidm.criteria.Criterion;
import com.powsybl.iidm.criteria.PropertyCriterion;
import com.powsybl.iidm.criteria.RegexCriterion;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractEquipmentCriterionContingencyList
implements ContingencyList {
    private final String name;
    private final IdentifiableType identifiableType;
    private final List<PropertyCriterion> propertyCriteria;
    private final RegexCriterion regexCriterion;

    protected AbstractEquipmentCriterionContingencyList(String name, IdentifiableType identifiableType, List<PropertyCriterion> propertyCriteria, RegexCriterion regexCriterion) {
        this.name = Objects.requireNonNull(name);
        this.identifiableType = identifiableType;
        this.propertyCriteria = ImmutableList.copyOf((Collection)Objects.requireNonNull(propertyCriteria));
        this.regexCriterion = regexCriterion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Contingency> getContingencies(Network network) {
        return network.getIdentifiableStream(this.getIdentifiableType()).filter(identifiable -> this.getCountryCriterion() == null || this.getCountryCriterion().filter(identifiable, this.getIdentifiableType())).filter(identifiable -> this.getNominalVoltageCriterion() == null || this.getNominalVoltageCriterion().filter(identifiable, this.getIdentifiableType())).filter(identifiable -> this.getPropertyCriteria().stream().allMatch(propertyCriterion -> propertyCriterion.filter(identifiable, this.getIdentifiableType()))).filter(identifiable -> this.getRegexCriterion() == null || this.getRegexCriterion().filter(identifiable, this.getIdentifiableType())).map(identifiable -> new Contingency(identifiable.getId(), ContingencyElementFactory.create(identifiable))).collect(Collectors.toList());
    }

    public IdentifiableType getIdentifiableType() {
        return this.identifiableType;
    }

    public List<PropertyCriterion> getPropertyCriteria() {
        return this.propertyCriteria;
    }

    public RegexCriterion getRegexCriterion() {
        return this.regexCriterion;
    }

    public abstract Criterion getCountryCriterion();

    public abstract Criterion getNominalVoltageCriterion();
}

