/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ieeecdf.model;

import com.powsybl.ieeecdf.model.IeeeCdfBranch;
import com.powsybl.ieeecdf.model.IeeeCdfBus;
import com.powsybl.ieeecdf.model.IeeeCdfInterchangeData;
import com.powsybl.ieeecdf.model.IeeeCdfLossZone;
import com.powsybl.ieeecdf.model.IeeeCdfModel;
import com.powsybl.ieeecdf.model.IeeeCdfTieLine;
import com.powsybl.ieeecdf.model.IeeeCdfTitle;
import com.univocity.parsers.common.processor.BeanWriterProcessor;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import com.univocity.parsers.fixed.FixedWidthWriter;
import com.univocity.parsers.fixed.FixedWidthWriterSettings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class IeeeCdfWriter {
    private final IeeeCdfModel model;

    public IeeeCdfWriter(IeeeCdfModel model) {
        this.model = Objects.requireNonNull(model);
    }

    private static <T> void writeRecords(Writer writer, List<T> beans, Class<T> aClass) {
        FixedWidthWriterSettings settings = new FixedWidthWriterSettings();
        settings.setWriteLineSeparatorAfterRecord(true);
        BeanWriterProcessor processor = new BeanWriterProcessor(aClass);
        settings.setRowWriterProcessor((RowWriterProcessor)processor);
        new FixedWidthWriter(writer, settings).processRecords(beans);
    }

    public void write(BufferedWriter writer) throws IOException {
        IeeeCdfWriter.writeRecords(writer, Collections.singletonList(this.model.getTitle()), IeeeCdfTitle.class);
        writer.write(String.format("BUS DATA FOLLOWS                            %d ITEMS", this.model.getBuses().size()));
        writer.newLine();
        IeeeCdfWriter.writeRecords(writer, this.model.getBuses(), IeeeCdfBus.class);
        writer.write("-999");
        writer.newLine();
        writer.write(String.format("BRANCH DATA FOLLOWS                         %d ITEMS", this.model.getBranches().size()));
        writer.newLine();
        IeeeCdfWriter.writeRecords(writer, this.model.getBranches(), IeeeCdfBranch.class);
        writer.write("-999");
        writer.newLine();
        writer.write(String.format("LOSS ZONES FOLLOWS                     %d ITEMS", this.model.getLossZones().size()));
        writer.newLine();
        IeeeCdfWriter.writeRecords(writer, this.model.getLossZones(), IeeeCdfLossZone.class);
        writer.write("-99");
        writer.newLine();
        writer.write(String.format("INTERCHANGE DATA FOLLOWS                 %d ITEMS", this.model.getInterchangeData().size()));
        writer.newLine();
        IeeeCdfWriter.writeRecords(writer, this.model.getInterchangeData(), IeeeCdfInterchangeData.class);
        writer.write("-9");
        writer.newLine();
        writer.write(String.format("TIE LINES FOLLOWS                     %d ITEMS", this.model.getTieLines().size()));
        writer.newLine();
        IeeeCdfWriter.writeRecords(writer, this.model.getTieLines(), IeeeCdfTieLine.class);
        writer.write("-999");
        writer.newLine();
        writer.write("END OF DATA");
        writer.newLine();
    }
}

