/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ieeecdf.model;

import com.univocity.parsers.conversions.ObjectConversion;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;

public class LocalDateConversion
extends ObjectConversion<LocalDate> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("M/d/").optionalStart().appendPattern("uuuu").optionalEnd().optionalStart().appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 1970).optionalEnd().toFormatter();
    private static final String INVALID_DATE = "0 /0 /0 ";

    protected LocalDate fromString(String str) {
        if (!str.equals(INVALID_DATE)) {
            return LocalDate.parse(str, FORMATTER);
        }
        return null;
    }

    public String revert(LocalDate date) {
        return date != null ? FORMATTER.format(date) : INVALID_DATE;
    }
}

