/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.ieeecdf.model;

import com.powsybl.ieeecdf.model.IeeeCdfBranch;
import com.powsybl.ieeecdf.model.IeeeCdfBus;
import com.powsybl.ieeecdf.model.IeeeCdfInterchangeData;
import com.powsybl.ieeecdf.model.IeeeCdfLossZone;
import com.powsybl.ieeecdf.model.IeeeCdfModel;
import com.powsybl.ieeecdf.model.IeeeCdfTieLine;
import com.powsybl.ieeecdf.model.IeeeCdfTitle;
import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.fixed.FixedWidthParser;
import com.univocity.parsers.fixed.FixedWidthParserSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IeeeCdfReader {
    public IeeeCdfModel read(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        List<IeeeCdfTitle> parsedLines = IeeeCdfReader.parseLines(Collections.singletonList(line), IeeeCdfTitle.class);
        if (parsedLines.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse the IeeeCdfModel");
        }
        IeeeCdfTitle title = parsedLines.get(0);
        IeeeCdfModel model = new IeeeCdfModel(title);
        IeeeCdfSection section = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("BUS DATA FOLLOWS")) {
                section = IeeeCdfSection.BUS;
                continue;
            }
            if (line.startsWith("BRANCH DATA FOLLOWS")) {
                section = IeeeCdfSection.BRANCH;
                continue;
            }
            if (line.startsWith("LOSS ZONES FOLLOWS")) {
                section = IeeeCdfSection.LOSS_ZONES;
                continue;
            }
            if (line.startsWith("INTERCHANGE DATA FOLLOWS")) {
                section = IeeeCdfSection.INTERCHANGE_DATA;
                continue;
            }
            if (line.startsWith("TIE LINES FOLLOWS ")) {
                section = IeeeCdfSection.TIE_LINES;
                continue;
            }
            if (line.startsWith("-9")) {
                if (section == null) continue;
                this.parseLines(lines, model, section);
                lines.clear();
                section = null;
                continue;
            }
            if (section == null) continue;
            lines.add(line);
        }
        return model;
    }

    private static <T> List<T> parseLines(List<String> lines, Class<T> aClass) {
        FixedWidthParserSettings settings = new FixedWidthParserSettings();
        BeanListProcessor processor = new BeanListProcessor(aClass);
        settings.setProcessor((Processor)processor);
        FixedWidthParser parser = new FixedWidthParser(settings);
        for (String line : lines) {
            parser.parseLine(line);
        }
        return processor.getBeans();
    }

    private void parseLines(List<String> lines, IeeeCdfModel model, IeeeCdfSection section) {
        switch (section) {
            case BUS: {
                model.getBuses().addAll(IeeeCdfReader.parseLines(lines, IeeeCdfBus.class));
                break;
            }
            case BRANCH: {
                model.getBranches().addAll(IeeeCdfReader.parseLines(lines, IeeeCdfBranch.class));
                break;
            }
            case LOSS_ZONES: {
                model.getLossZones().addAll(IeeeCdfReader.parseLines(lines, IeeeCdfLossZone.class));
                break;
            }
            case INTERCHANGE_DATA: {
                model.getInterchangeData().addAll(IeeeCdfReader.parseLines(lines, IeeeCdfInterchangeData.class));
                break;
            }
            case TIE_LINES: {
                model.getTieLines().addAll(IeeeCdfReader.parseLines(lines, IeeeCdfTieLine.class));
                break;
            }
            default: {
                throw new IllegalStateException("Section unknown: " + section);
            }
        }
    }

    static enum IeeeCdfSection {
        BUS,
        BRANCH,
        LOSS_ZONES,
        INTERCHANGE_DATA,
        TIE_LINES;

    }
}

