/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.OperationalLimits;
import com.powsybl.iidm.network.Terminal;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public interface Branch<I extends Branch<I>>
extends Identifiable<I> {
    public Terminal getTerminal1();

    public Terminal getTerminal2();

    public Terminal getTerminal(Side var1);

    public Terminal getTerminal(String var1);

    public Side getSide(Terminal var1);

    default public Collection<OperationalLimits> getOperationalLimits1() {
        return this.getCurrentLimits1().map(l -> Collections.singletonList(l)).orElseGet(Collections::emptyList);
    }

    public Optional<CurrentLimits> getCurrentLimits1();

    public CurrentLimits getNullableCurrentLimits1();

    public Optional<ActivePowerLimits> getActivePowerLimits1();

    public ActivePowerLimits getNullableActivePowerLimits1();

    public Optional<ApparentPowerLimits> getApparentPowerLimits1();

    public ApparentPowerLimits getNullableApparentPowerLimits1();

    public CurrentLimitsAdder newCurrentLimits1();

    public ActivePowerLimitsAdder newActivePowerLimits1();

    public ApparentPowerLimitsAdder newApparentPowerLimits1();

    default public Collection<OperationalLimits> getOperationalLimits2() {
        return this.getCurrentLimits2().map(l -> Collections.singletonList(l)).orElseGet(Collections::emptyList);
    }

    public Optional<CurrentLimits> getCurrentLimits2();

    public CurrentLimits getNullableCurrentLimits2();

    public Optional<ActivePowerLimits> getActivePowerLimits2();

    public ActivePowerLimits getNullableActivePowerLimits2();

    public Optional<ApparentPowerLimits> getApparentPowerLimits2();

    public ApparentPowerLimits getNullableApparentPowerLimits2();

    public CurrentLimitsAdder newCurrentLimits2();

    public ActivePowerLimitsAdder newActivePowerLimits2();

    public ApparentPowerLimitsAdder newApparentPowerLimits2();

    default public Optional<CurrentLimits> getCurrentLimits(Side side) {
        switch (side) {
            case ONE: {
                return this.getCurrentLimits1();
            }
            case TWO: {
                return this.getCurrentLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits(Side side) {
        switch (side) {
            case ONE: {
                return this.getActivePowerLimits1();
            }
            case TWO: {
                return this.getActivePowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits(Side side) {
        switch (side) {
            case ONE: {
                return this.getApparentPowerLimits1();
            }
            case TWO: {
                return this.getApparentPowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public Optional<? extends LoadingLimits> getLimits(LimitType type, Side side) {
        switch (type) {
            case CURRENT: {
                return this.getCurrentLimits(side);
            }
            case ACTIVE_POWER: {
                return this.getActivePowerLimits(side);
            }
            case APPARENT_POWER: {
                return this.getApparentPowerLimits(side);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    default public CurrentLimits getNullableCurrentLimits(Side side) {
        switch (side) {
            case ONE: {
                return this.getNullableCurrentLimits1();
            }
            case TWO: {
                return this.getNullableCurrentLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public ActivePowerLimits getNullableActivePowerLimits(Side side) {
        switch (side) {
            case ONE: {
                return this.getNullableActivePowerLimits1();
            }
            case TWO: {
                return this.getNullableActivePowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits(Side side) {
        switch (side) {
            case ONE: {
                return this.getNullableApparentPowerLimits1();
            }
            case TWO: {
                return this.getNullableApparentPowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public LoadingLimits getNullableLimits(LimitType type, Side side) {
        switch (type) {
            case CURRENT: {
                return this.getNullableCurrentLimits(side);
            }
            case ACTIVE_POWER: {
                return this.getNullableActivePowerLimits(side);
            }
            case APPARENT_POWER: {
                return this.getNullableApparentPowerLimits(side);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    public boolean isOverloaded();

    public boolean isOverloaded(float var1);

    public int getOverloadDuration();

    public boolean checkPermanentLimit(Side var1, float var2, LimitType var3);

    public boolean checkPermanentLimit(Side var1, LimitType var2);

    public boolean checkPermanentLimit1(float var1, LimitType var2);

    public boolean checkPermanentLimit1(LimitType var1);

    public boolean checkPermanentLimit2(float var1, LimitType var2);

    public boolean checkPermanentLimit2(LimitType var1);

    public Overload checkTemporaryLimits(Side var1, float var2, LimitType var3);

    public Overload checkTemporaryLimits(Side var1, LimitType var2);

    public Overload checkTemporaryLimits1(float var1, LimitType var2);

    public Overload checkTemporaryLimits1(LimitType var1);

    public Overload checkTemporaryLimits2(float var1, LimitType var2);

    public Overload checkTemporaryLimits2(LimitType var1);

    public static enum Side {
        ONE,
        TWO;

    }

    public static interface Overload {
        public LoadingLimits.TemporaryLimit getTemporaryLimit();

        public double getPreviousLimit();

        public String getPreviousLimitName();
    }
}

