/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import java.util.Collections;
import java.util.stream.Stream;

public interface Bus
extends Identifiable<Bus> {
    public VoltageLevel getVoltageLevel();

    public double getV();

    public Bus setV(double var1);

    public double getAngle();

    public Bus setAngle(double var1);

    public double getP();

    public double getQ();

    default public double getFictitiousP0() {
        return 0.0;
    }

    default public Bus setFictitiousP0(double p0) {
        return this;
    }

    default public double getFictitiousQ0() {
        return 0.0;
    }

    default public Bus setFictitiousQ0(double q0) {
        return this;
    }

    public Component getConnectedComponent();

    public boolean isInMainConnectedComponent();

    public Component getSynchronousComponent();

    public boolean isInMainSynchronousComponent();

    public int getConnectedTerminalCount();

    public Iterable<Line> getLines();

    public Stream<Line> getLineStream();

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers();

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream();

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers();

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream();

    public Iterable<Generator> getGenerators();

    public Stream<Generator> getGeneratorStream();

    public Iterable<Battery> getBatteries();

    public Stream<Battery> getBatteryStream();

    public Iterable<Load> getLoads();

    public Stream<Load> getLoadStream();

    public Iterable<ShuntCompensator> getShuntCompensators();

    public Stream<ShuntCompensator> getShuntCompensatorStream();

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter var1);

    default public Iterable<DanglingLine> getDanglingLines() {
        return this.getDanglingLines(DanglingLineFilter.ALL);
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter var1);

    default public Stream<DanglingLine> getDanglingLineStream() {
        return this.getDanglingLineStream(DanglingLineFilter.ALL);
    }

    public Iterable<StaticVarCompensator> getStaticVarCompensators();

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream();

    public Iterable<LccConverterStation> getLccConverterStations();

    public Stream<LccConverterStation> getLccConverterStationStream();

    public Iterable<VscConverterStation> getVscConverterStations();

    public Stream<VscConverterStation> getVscConverterStationStream();

    public void visitConnectedEquipments(TopologyVisitor var1);

    public void visitConnectedOrConnectableEquipments(TopologyVisitor var1);

    default public Iterable<? extends Terminal> getConnectedTerminals() {
        return Collections.emptyList();
    }

    default public Stream<? extends Terminal> getConnectedTerminalStream() {
        return Stream.empty();
    }

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.BUS;
    }
}

