/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.AbstractBusRef;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyLevel;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IdBasedBusRef
extends AbstractBusRef {
    private final String id;
    private final Branch.Side side;

    public IdBasedBusRef(String id) {
        this.id = Objects.requireNonNull(id);
        this.side = null;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public IdBasedBusRef(@JsonProperty(value="id") String id, @JsonProperty(value="side") Branch.Side side) {
        this.id = Objects.requireNonNull(id);
        this.side = side;
    }

    @Override
    protected Optional<Bus> resolveByLevel(Network network, TopologyLevel level) {
        Identifiable<?> identifiable = network.getIdentifiable(this.id);
        if (identifiable == null) {
            return Optional.empty();
        }
        if (this.side == null) {
            if (identifiable instanceof Bus) {
                Bus bus = (Bus)identifiable;
                if (level == TopologyLevel.BUS_BRANCH) {
                    return bus.getConnectedTerminalStream().map(t -> t.getBusView().getBus()).filter(Objects::nonNull).findFirst();
                }
                return Optional.of(bus);
            }
            if (identifiable instanceof Injection) {
                Injection injection = (Injection)identifiable;
                return IdBasedBusRef.chooseBusByLevel(injection.getTerminal(), level);
            }
            throw new PowsyblException(this.id + " is not a bus or injection.");
        }
        if (identifiable instanceof Branch) {
            Branch branch = (Branch)identifiable;
            return IdBasedBusRef.chooseBusByLevel(switch (this.side) {
                case Branch.Side.ONE -> branch.getTerminal1();
                case Branch.Side.TWO -> branch.getTerminal2();
                default -> throw new IllegalStateException("Unexpected side: " + this.side);
            }, level);
        }
        throw new PowsyblException(this.id + " is not a branch.");
    }

    public String getId() {
        return this.id;
    }

    public Branch.Side getSide() {
        return this.side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdBasedBusRef)) {
            return false;
        }
        IdBasedBusRef that = (IdBasedBusRef)o;
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        return this.getSide() != null ? this.getSide().equals((Object)that.getSide()) : that.getSide() == null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.side});
    }
}

