/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.FileDataSource;
import com.powsybl.commons.datasource.GenericReadOnlyDataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.network.ImportersLoader;
import com.powsybl.iidm.network.ImportersServiceLoader;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Importers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Importers.class);
    static final String UNSUPPORTED_FILE_FORMAT_OR_INVALID_FILE = "Unsupported file format or invalid file.";

    private Importers() {
    }

    public static Network importData(ImportersLoader loader, String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager, ImportConfig config, Reporter reporter) {
        Importer importer = Importer.find(loader, format, computationManager, config);
        if (importer == null) {
            throw new PowsyblException("Import format " + format + " not supported");
        }
        return importer.importData(dataSource, NetworkFactory.findDefault(), parameters, reporter);
    }

    public static Network importData(ImportersLoader loader, String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager, ImportConfig config) {
        return Importers.importData(loader, format, dataSource, parameters, computationManager, config, Reporter.NO_OP);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager, Reporter reporter) {
        return Importers.importData(new ImportersServiceLoader(), format, dataSource, parameters, computationManager, ImportConfig.CACHE.get(), reporter);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters, ComputationManager computationManager) {
        return Importers.importData(new ImportersServiceLoader(), format, dataSource, parameters, computationManager, ImportConfig.CACHE.get(), Reporter.NO_OP);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters, Reporter reporter) {
        return Importers.importData(new ImportersServiceLoader(), format, dataSource, parameters, LocalComputationManager.getDefault(), ImportConfig.CACHE.get(), reporter);
    }

    public static Network importData(String format, ReadOnlyDataSource dataSource, Properties parameters) {
        return Importers.importData(format, dataSource, parameters, LocalComputationManager.getDefault());
    }

    public static Network importData(String format, String directory, String baseName, Properties parameters) {
        return Importers.importData(format, (ReadOnlyDataSource)new FileDataSource(Paths.get(directory, new String[0]), baseName), parameters);
    }

    private static void doImport(ReadOnlyDataSource dataSource, Importer importer, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, NetworkFactory networkFactory, Reporter reporter) {
        Objects.requireNonNull(consumer);
        try {
            if (listener != null) {
                listener.accept(dataSource);
            }
            Network network = importer.importData(dataSource, networkFactory, parameters, reporter);
            consumer.accept(network);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    private static void addDataSource(Path dir, Path file, Importer importer, List<ReadOnlyDataSource> dataSources) {
        Objects.requireNonNull(importer);
        String caseBaseName = DataSourceUtil.getBaseName((Path)file);
        GenericReadOnlyDataSource ds = new GenericReadOnlyDataSource(dir, caseBaseName);
        if (importer.exists((ReadOnlyDataSource)ds)) {
            dataSources.add((ReadOnlyDataSource)ds);
        }
    }

    private static void importAll(Path parent, Importer importer, List<ReadOnlyDataSource> dataSources) throws IOException {
        if (Files.isDirectory(parent, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(parent);){
                stream.sorted().forEach(child -> {
                    if (Files.isDirectory(child, new LinkOption[0])) {
                        try {
                            Importers.importAll(child, importer, dataSources);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    } else {
                        Importers.addDataSource(parent, child, importer, dataSources);
                    }
                });
            }
        } else if (parent.getParent() != null) {
            Importers.addDataSource(parent.getParent(), parent, importer, dataSources);
        }
    }

    public static void importAll(Path dir, Importer importer, boolean parallel, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, Reporter reporter) throws IOException, InterruptedException, ExecutionException {
        Importers.importAll(dir, importer, parallel, parameters, consumer, listener, NetworkFactory.findDefault(), reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importAll(Path dir, Importer importer, boolean parallel, Properties parameters, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener, NetworkFactory networkFactory, Reporter reporter) throws IOException, InterruptedException, ExecutionException {
        ArrayList<ReadOnlyDataSource> dataSources = new ArrayList<ReadOnlyDataSource>();
        Importers.importAll(dir, importer, dataSources);
        if (parallel) {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            try {
                List futures = dataSources.stream().map(ds -> {
                    Reporter child = Importers.createSubReporter(reporter, ds);
                    return executor.submit(() -> Importers.doImport(ds, importer, parameters, consumer, listener, networkFactory, child));
                }).collect(Collectors.toList());
                for (Future future : futures) {
                    future.get();
                }
            }
            finally {
                executor.shutdownNow();
            }
        } else {
            for (ReadOnlyDataSource dataSource : dataSources) {
                Importers.doImport(dataSource, importer, parameters, consumer, listener, networkFactory, Importers.createSubReporter(reporter, dataSource));
            }
        }
    }

    private static Reporter createSubReporter(Reporter reporter, ReadOnlyDataSource ds) {
        return reporter.createSubReporter("importDataSource", "Import data source ${dataSource}", "dataSource", (Object)ds.getBaseName());
    }

    public static void importAll(Path dir, Importer importer, boolean parallel, Consumer<Network> consumer, Consumer<ReadOnlyDataSource> listener) throws IOException, InterruptedException, ExecutionException {
        Importers.importAll(dir, importer, parallel, null, consumer, listener, Reporter.NO_OP);
    }

    public static void importAll(Path dir, Importer importer, boolean parallel, Consumer<Network> consumer) throws IOException, InterruptedException, ExecutionException {
        Importers.importAll(dir, importer, parallel, consumer, null);
    }
}

