/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraversalType;
import com.powsybl.math.graph.TraverseResult;
import java.util.Optional;

public interface Terminal {
    public VoltageLevel getVoltageLevel();

    public NodeBreakerView getNodeBreakerView();

    public BusBreakerView getBusBreakerView();

    public BusView getBusView();

    public Connectable getConnectable();

    public double getP();

    public Terminal setP(double var1);

    public double getQ();

    public Terminal setQ(double var1);

    public double getI();

    public boolean connect();

    public boolean disconnect();

    public boolean isConnected();

    public void traverse(TopologyTraverser var1);

    public void traverse(TopologyTraverser var1, TraversalType var2);

    public static Optional<ThreeSides> getConnectableSide(Terminal terminal) {
        Connectable c = terminal.getConnectable();
        if (c instanceof Injection) {
            return Optional.empty();
        }
        if (c instanceof Branch) {
            Branch branch = (Branch)((Object)c);
            return Optional.of(Terminal.toSide(branch.getSide(terminal)));
        }
        if (c instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer transformer = (ThreeWindingsTransformer)c;
            return Optional.of(Terminal.toSide(transformer.getSide(terminal)));
        }
        throw new IllegalStateException("Unexpected Connectable instance: " + c.getClass());
    }

    private static ThreeSides toSide(Branch.Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Branch.Side.ONE -> ThreeSides.ONE;
            case Branch.Side.TWO -> ThreeSides.TWO;
        };
    }

    private static ThreeSides toSide(ThreeWindingsTransformer.Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeWindingsTransformer.Side.ONE -> ThreeSides.ONE;
            case ThreeWindingsTransformer.Side.TWO -> ThreeSides.TWO;
            case ThreeWindingsTransformer.Side.THREE -> ThreeSides.THREE;
        };
    }

    public static Terminal getTerminal(Identifiable<?> identifiable, ThreeSides side) {
        if (identifiable instanceof Injection) {
            Injection injection = (Injection)identifiable;
            return injection.getTerminal();
        }
        if (identifiable instanceof Branch) {
            Branch branch = (Branch)identifiable;
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case ThreeSides.ONE -> branch.getTerminal1();
                case ThreeSides.TWO -> branch.getTerminal2();
                case ThreeSides.THREE -> throw new IllegalStateException("Unexpected Branch side: " + side.name());
            };
        }
        if (identifiable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer transformer = (ThreeWindingsTransformer)identifiable;
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case ThreeSides.ONE -> transformer.getLeg1().getTerminal();
                case ThreeSides.TWO -> transformer.getLeg2().getTerminal();
                case ThreeSides.THREE -> transformer.getLeg3().getTerminal();
            };
        }
        throw new PowsyblException("Unexpected terminal reference identifiable instance: " + identifiable.getClass());
    }

    public static interface TopologyTraverser {
        public TraverseResult traverse(Terminal var1, boolean var2);

        public TraverseResult traverse(Switch var1);
    }

    public static interface BusView {
        public Bus getBus();

        public Bus getConnectableBus();
    }

    public static interface BusBreakerView {
        public Bus getBus();

        public Bus getConnectableBus();

        public void setConnectableBus(String var1);

        public void moveConnectable(String var1, boolean var2);
    }

    public static interface NodeBreakerView {
        public int getNode();

        public void moveConnectable(int var1, String var2);
    }
}

