/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.PhaseTapChangerHolder;
import com.powsybl.iidm.network.RatioTapChangerHolder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface ThreeWindingsTransformer
extends Connectable<ThreeWindingsTransformer> {
    public Terminal getTerminal(Side var1);

    public Side getSide(Terminal var1);

    public Optional<Substation> getSubstation();

    default public Substation getNullableSubstation() {
        return this.getSubstation().orElse(null);
    }

    public Leg getLeg1();

    public Leg getLeg2();

    public Leg getLeg3();

    default public Leg getLeg(Side side) {
        switch (side) {
            case ONE: {
                return this.getLeg1();
            }
            case TWO: {
                return this.getLeg2();
            }
            case THREE: {
                return this.getLeg3();
            }
        }
        throw new PowsyblException("Can't get leg from side. Unsupported Side \"" + side + "\"");
    }

    default public Stream<Leg> getLegStream() {
        return Stream.of(this.getLeg1(), this.getLeg2(), this.getLeg3());
    }

    default public List<Leg> getLegs() {
        return Arrays.asList(this.getLeg1(), this.getLeg2(), this.getLeg3());
    }

    public double getRatedU0();

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.THREE_WINDINGS_TRANSFORMER;
    }

    public static enum Side {
        ONE,
        TWO,
        THREE;

    }

    public static interface Leg
    extends RatioTapChangerHolder,
    PhaseTapChangerHolder,
    FlowsLimitsHolder {
        public Terminal getTerminal();

        public double getR();

        public Leg setR(double var1);

        public double getX();

        public Leg setX(double var1);

        public double getG();

        public Leg setG(double var1);

        public double getB();

        public Leg setB(double var1);

        public double getRatedU();

        public Leg setRatedU(double var1);

        default public double getRatedS() {
            throw new UnsupportedOperationException();
        }

        default public Leg setRatedS(double ratedS) {
            throw new UnsupportedOperationException();
        }
    }
}

