/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.util.LinkData;
import java.util.Objects;
import org.apache.commons.math3.complex.Complex;

public class BranchData {
    private final String id;
    private final double r;
    private final double x;
    private final double z;
    private final double y;
    private final double ksi;
    private final double rho1;
    private final double rho2;
    private final double u1;
    private final double u2;
    private final double theta1;
    private final double theta2;
    private final double alpha1;
    private final double alpha2;
    private final double g1;
    private final double g2;
    private final double b1;
    private final double b2;
    private final double p1;
    private final double q1;
    private final double p2;
    private final double q2;
    int phaseAngleClock;
    private final boolean connected1;
    private final boolean connected2;
    private final boolean mainComponent1;
    private final boolean mainComponent2;
    private double computedP1;
    private double computedQ1;
    private double computedP2;
    private double computedQ2;

    public BranchData(String id, double r, double x, double rho1, double rho2, double u1, double u2, double theta1, double theta2, double alpha1, double alpha2, double g1, double g2, double b1, double b2, double p1, double q1, double p2, double q2, boolean connected1, boolean connected2, boolean mainComponent1, boolean mainComponent2, double epsilonX, boolean applyReactanceCorrection) {
        this(id, r, x, rho1, rho2, u1, u2, theta1, theta2, alpha1, alpha2, g1, g2, b1, b2, p1, q1, p2, q2, connected1, connected2, mainComponent1, mainComponent2, 0, epsilonX, applyReactanceCorrection);
    }

    public BranchData(String id, double r, double x, double rho1, double rho2, double u1, double u2, double theta1, double theta2, double alpha1, double alpha2, double g1, double g2, double b1, double b2, double p1, double q1, double p2, double q2, boolean connected1, boolean connected2, boolean mainComponent1, boolean mainComponent2, int phaseAngleClock, double epsilonX, boolean applyReactanceCorrection) {
        this.id = id;
        this.r = r;
        this.x = x;
        double fixedX = LinkData.getFixedX(x, epsilonX, applyReactanceCorrection);
        this.z = Math.hypot(r, fixedX);
        this.y = 1.0 / this.z;
        this.ksi = Math.atan2(r, fixedX);
        this.rho1 = rho1;
        this.rho2 = rho2;
        this.u1 = u1;
        this.u2 = u2;
        this.theta1 = theta1;
        this.theta2 = theta2;
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        this.g1 = g1;
        this.g2 = g2;
        this.b1 = b1;
        this.b2 = b2;
        this.p1 = p1;
        this.q1 = q1;
        this.p2 = p2;
        this.q2 = q2;
        this.phaseAngleClock = phaseAngleClock;
        this.connected1 = connected1;
        this.connected2 = connected2;
        this.mainComponent1 = mainComponent1;
        this.mainComponent2 = mainComponent2;
        this.computeValues();
    }

    public BranchData(Line line, double epsilonX, boolean applyReactanceCorrection) {
        this(Objects.requireNonNull(line), epsilonX, applyReactanceCorrection, 0, line.getR(), line.getX(), line.getG1(), line.getG2(), line.getB1(), line.getB2(), 1.0, 1.0, 0.0, 0.0, line.getTerminal1(), line.getTerminal2());
    }

    public BranchData(TwoWindingsTransformer twt, double epsilonX, boolean applyReactanceCorrection, boolean twtSplitShuntAdmittance) {
        this(twt, 0, epsilonX, applyReactanceCorrection, twtSplitShuntAdmittance);
    }

    public BranchData(TwoWindingsTransformer twt, int phaseAngleClock, double epsilonX, boolean applyReactanceCorrection, boolean twtSplitShuntAdmittance) {
        this(Objects.requireNonNull(twt), epsilonX, applyReactanceCorrection, phaseAngleClock, BranchData.getR(twt), BranchData.getX(twt), BranchData.getG1(twt, twtSplitShuntAdmittance), BranchData.getG2(twt, twtSplitShuntAdmittance), BranchData.getB1(twt, twtSplitShuntAdmittance), BranchData.getB2(twt, twtSplitShuntAdmittance), BranchData.getRho1(twt), 1.0, twt.getOptionalPhaseTapChanger().map(ptc -> Math.toRadians(((PhaseTapChangerStep)ptc.getCurrentStep()).getAlpha())).orElse(0.0), 0.0, twt.getTerminal1(), twt.getTerminal2());
    }

    public BranchData(TieLine tieLine, double epsilonX, boolean applyReactanceCorrection) {
        this(Objects.requireNonNull(tieLine), epsilonX, applyReactanceCorrection, 0, tieLine.getR(), tieLine.getX(), tieLine.getG1(), tieLine.getG2(), tieLine.getB1(), tieLine.getB2(), 1.0, 1.0, 0.0, 0.0, tieLine.getDanglingLine1().getTerminal(), tieLine.getDanglingLine2().getTerminal());
    }

    private BranchData(Identifiable<?> identifiable, double epsilonX, boolean applyReactanceCorrection, int phaseAngleClock, double r, double x, double g1, double g2, double b1, double b2, double rho1, double rho2, double alpha1, double alpha2, Terminal terminal1, Terminal terminal2) {
        this.phaseAngleClock = phaseAngleClock;
        this.r = r;
        this.x = x;
        this.g1 = g1;
        this.g2 = g2;
        this.b1 = b1;
        this.b2 = b2;
        this.rho1 = rho1;
        this.rho2 = rho2;
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        this.id = identifiable.getId();
        Bus bus1 = terminal1.getBusView().getBus();
        Bus bus2 = terminal2.getBusView().getBus();
        Bus connectableBus1 = terminal1.getBusView().getConnectableBus();
        Bus connectableBus2 = terminal2.getBusView().getConnectableBus();
        double fixedX = LinkData.getFixedX(x, epsilonX, applyReactanceCorrection);
        this.z = Math.hypot(r, fixedX);
        this.y = 1.0 / this.z;
        this.ksi = Math.atan2(r, fixedX);
        this.u1 = bus1 != null ? bus1.getV() : Double.NaN;
        this.u2 = bus2 != null ? bus2.getV() : Double.NaN;
        this.theta1 = bus1 != null ? Math.toRadians(bus1.getAngle()) : Double.NaN;
        this.theta2 = bus2 != null ? Math.toRadians(bus2.getAngle()) : Double.NaN;
        this.p1 = terminal1.getP();
        this.q1 = terminal1.getQ();
        this.p2 = terminal2.getP();
        this.q2 = terminal2.getQ();
        this.connected1 = bus1 != null;
        this.connected2 = bus2 != null;
        boolean connectableMainComponent1 = connectableBus1 != null && connectableBus1.isInMainConnectedComponent();
        boolean connectableMainComponent2 = connectableBus2 != null && connectableBus2.isInMainConnectedComponent();
        this.mainComponent1 = bus1 != null ? bus1.isInMainConnectedComponent() : connectableMainComponent1;
        this.mainComponent2 = bus2 != null ? bus2.isInMainConnectedComponent() : connectableMainComponent2;
        this.computeValues();
    }

    private static double getValue(double initialValue, double rtcStepValue, double ptcStepValue) {
        return initialValue * (1.0 + rtcStepValue / 100.0) * (1.0 + ptcStepValue / 100.0);
    }

    private static double getR(TwoWindingsTransformer twt) {
        return BranchData.getValue(twt.getR(), twt.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getR()).orElse(0.0), twt.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getR()).orElse(0.0));
    }

    private static double getX(TwoWindingsTransformer twt) {
        return BranchData.getValue(twt.getX(), twt.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getX()).orElse(0.0), twt.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getX()).orElse(0.0));
    }

    private static double getG1(TwoWindingsTransformer twt, boolean twtSplitShuntAdmittance) {
        return BranchData.getValue(twtSplitShuntAdmittance ? twt.getG() / 2.0 : twt.getG(), twt.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getG()).orElse(0.0), twt.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getG()).orElse(0.0));
    }

    private static double getB1(TwoWindingsTransformer twt, boolean twtSplitShuntAdmittance) {
        return BranchData.getValue(twtSplitShuntAdmittance ? twt.getB() / 2.0 : twt.getB(), twt.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getB()).orElse(0.0), twt.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getB()).orElse(0.0));
    }

    private static double getG2(TwoWindingsTransformer twt, boolean twtSplitShuntAdmittance) {
        return BranchData.getValue(twtSplitShuntAdmittance ? twt.getG() / 2.0 : 0.0, twt.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getG()).orElse(0.0), twt.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getG()).orElse(0.0));
    }

    private static double getB2(TwoWindingsTransformer twt, boolean twtSplitShuntAdmittance) {
        return BranchData.getValue(twtSplitShuntAdmittance ? twt.getB() / 2.0 : 0.0, twt.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getB()).orElse(0.0), twt.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getB()).orElse(0.0));
    }

    private static double getRho1(TwoWindingsTransformer twt) {
        double rho = twt.getRatedU2() / twt.getRatedU1();
        rho *= twt.getOptionalRatioTapChanger().map(rtc -> ((RatioTapChangerStep)rtc.getCurrentStep()).getRho()).orElse(1.0).doubleValue();
        return rho *= twt.getOptionalPhaseTapChanger().map(ptc -> ((PhaseTapChangerStep)ptc.getCurrentStep()).getRho()).orElse(1.0).doubleValue();
    }

    private void computeValues() {
        if (!this.connected1 && !this.connected2) {
            this.computedP1 = Double.NaN;
            this.computedQ1 = Double.NaN;
            this.computedP2 = Double.NaN;
            this.computedQ2 = Double.NaN;
        } else {
            double angle1 = -this.alpha1;
            double angle2 = -this.alpha2 - Math.toRadians(LinkData.getPhaseAngleClockDegrees(this.phaseAngleClock));
            LinkData.BranchAdmittanceMatrix branchAdmittance = LinkData.calculateBranchAdmittance(this.r, this.x, 1.0 / this.rho1, angle1, 1.0 / this.rho2, angle2, new Complex(this.g1, this.b1), new Complex(this.g2, this.b2));
            if (this.connected1 && this.connected2) {
                LinkData.Flow flow = LinkData.flowBothEnds(branchAdmittance.y11(), branchAdmittance.y12(), branchAdmittance.y21(), branchAdmittance.y22(), this.u1, this.theta1, this.u2, this.theta2);
                this.computedP1 = flow.fromTo.getReal();
                this.computedQ1 = flow.fromTo.getImaginary();
                this.computedP2 = flow.toFrom.getReal();
                this.computedQ2 = flow.toFrom.getImaginary();
            } else if (this.connected1) {
                Complex ysh = LinkData.kronAntenna(branchAdmittance.y11(), branchAdmittance.y12(), branchAdmittance.y21(), branchAdmittance.y22(), false);
                Complex sFrom = LinkData.flowYshunt(ysh, this.u1, this.theta1);
                this.computedP1 = sFrom.getReal();
                this.computedQ1 = sFrom.getImaginary();
                this.computedP2 = 0.0;
                this.computedQ2 = 0.0;
            } else {
                Complex ysh = LinkData.kronAntenna(branchAdmittance.y11(), branchAdmittance.y12(), branchAdmittance.y21(), branchAdmittance.y22(), true);
                Complex sTo = LinkData.flowYshunt(ysh, this.u2, this.theta2);
                this.computedP1 = 0.0;
                this.computedQ1 = 0.0;
                this.computedP2 = sTo.getReal();
                this.computedQ2 = sTo.getImaginary();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public double getR() {
        return this.r;
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    public double getY() {
        return this.y;
    }

    public double getKsi() {
        return this.ksi;
    }

    public double getRho1() {
        return this.rho1;
    }

    public double getRho2() {
        return this.rho2;
    }

    public double getU1() {
        return this.u1;
    }

    public double getU2() {
        return this.u2;
    }

    public double getTheta1() {
        return this.theta1;
    }

    public double getTheta2() {
        return this.theta2;
    }

    public double getAlpha1() {
        return this.alpha1;
    }

    public double getAlpha2() {
        return this.alpha2;
    }

    public double getG1() {
        return this.g1;
    }

    public double getG2() {
        return this.g2;
    }

    public double getB1() {
        return this.b1;
    }

    public double getB2() {
        return this.b2;
    }

    public boolean isConnected1() {
        return this.connected1;
    }

    public boolean isConnected2() {
        return this.connected2;
    }

    public boolean isMainComponent1() {
        return this.mainComponent1;
    }

    public boolean isMainComponent2() {
        return this.mainComponent2;
    }

    public double getP1() {
        return this.p1;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getP2() {
        return this.p2;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getComputedP1() {
        return this.computedP1;
    }

    public double getComputedQ1() {
        return this.computedQ1;
    }

    public double getComputedP2() {
        return this.computedP2;
    }

    public double getComputedQ2() {
        return this.computedQ2;
    }

    public double getComputedP(Branch.Side side) {
        Objects.requireNonNull(side);
        switch (side) {
            case ONE: {
                return this.computedP1;
            }
            case TWO: {
                return this.computedP2;
            }
        }
        throw new IllegalStateException("Unexpected side: " + side);
    }

    public double getComputedQ(Branch.Side side) {
        Objects.requireNonNull(side);
        switch (side) {
            case ONE: {
                return this.computedQ1;
            }
            case TWO: {
                return this.computedQ2;
            }
        }
        throw new IllegalStateException("Unexpected side: " + side);
    }

    public int getPhaseAngleClock() {
        return this.phaseAngleClock;
    }
}

