/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusRef;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyLevel;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractBusRef
implements BusRef {
    @Override
    public Optional<Bus> resolve(Network network, TopologyLevel level) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(level);
        if (TopologyLevel.NODE_BREAKER == level) {
            throw new IllegalArgumentException(level + " is not supported in resolve a BusRef.");
        }
        return this.resolveByLevel(network, level);
    }

    protected static Optional<Bus> chooseBusByLevel(Terminal t, TopologyLevel level) {
        if (level == TopologyLevel.BUS_BRANCH) {
            return Optional.ofNullable(t.getBusView().getBus());
        }
        return Optional.ofNullable(t.getBusBreakerView().getBus());
    }

    protected abstract Optional<Bus> resolveByLevel(Network var1, TopologyLevel var2);
}

