/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DefaultTopologyVisitor;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;

public abstract class AbstractTerminalTopologyVisitor
extends DefaultTopologyVisitor {
    public abstract void visitTerminal(Terminal var1);

    private void visitBranch(Branch branch, TwoSides side) {
        this.visitTerminal(branch.getTerminal(side));
    }

    @Override
    public void visitBusbarSection(BusbarSection busbarSection) {
        this.visitInjection(busbarSection);
    }

    @Override
    public void visitLine(Line line, TwoSides side) {
        this.visitBranch(line, side);
    }

    @Override
    public void visitTwoWindingsTransformer(TwoWindingsTransformer transformer, TwoSides side) {
        this.visitBranch(transformer, side);
    }

    @Override
    public void visitThreeWindingsTransformer(ThreeWindingsTransformer transformer, ThreeSides side) {
        this.visitTerminal(transformer.getTerminal(side));
    }

    private void visitInjection(Injection injection) {
        this.visitTerminal(injection.getTerminal());
    }

    @Override
    public void visitGenerator(Generator generator) {
        this.visitInjection(generator);
    }

    @Override
    public void visitBattery(Battery battery) {
        this.visitInjection(battery);
    }

    @Override
    public void visitLoad(Load load) {
        this.visitInjection(load);
    }

    @Override
    public void visitShuntCompensator(ShuntCompensator sc) {
        this.visitInjection(sc);
    }

    @Override
    public void visitDanglingLine(DanglingLine danglingLine) {
        this.visitInjection(danglingLine);
    }

    @Override
    public void visitStaticVarCompensator(StaticVarCompensator staticVarCompensator) {
        this.visitInjection(staticVarCompensator);
    }

    @Override
    public void visitHvdcConverterStation(HvdcConverterStation<?> converterStation) {
        this.visitInjection(converterStation);
    }
}

