/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Terminal;
import java.util.Iterator;

public final class Equipments {
    private Equipments() {
    }

    public static ConnectionInfo getConnectionInfoInBusBreakerView(Terminal t) {
        boolean connected;
        Bus bus = t.getBusBreakerView().getBus();
        if (bus != null) {
            connected = true;
        } else {
            connected = false;
            bus = t.getBusBreakerView().getConnectableBus();
            if (bus == null) {
                Iterator<Bus> itVLB = t.getVoltageLevel().getBusBreakerView().getBuses().iterator();
                if (itVLB.hasNext()) {
                    bus = itVLB.next();
                } else {
                    throw new PowsyblException("Cannot find a connection bus");
                }
            }
        }
        return new ConnectionInfo(bus, connected);
    }

    public static class ConnectionInfo {
        private final Bus connectionBus;
        private final boolean connected;

        public ConnectionInfo(Bus connectionBus, boolean connected) {
            this.connectionBus = connectionBus;
            this.connected = connected;
        }

        public Bus getConnectionBus() {
            return this.connectionBus;
        }

        public boolean isConnected() {
            return this.connected;
        }
    }
}

