/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.google.common.base.Suppliers;
import com.powsybl.commons.config.PlatformConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class ImportConfig {
    public static final Supplier<ImportConfig> CACHE = Suppliers.memoize(ImportConfig::load);
    private static final List<String> DEFAULT_POST_PROCESSORS = Collections.emptyList();
    private final List<String> postProcessors;

    public static ImportConfig load() {
        return ImportConfig.load(PlatformConfig.defaultConfig());
    }

    public static ImportConfig load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        List<String> postProcessors = platformConfig.getOptionalModuleConfig("import").flatMap(config -> config.getOptionalStringListProperty("postProcessors")).orElse(DEFAULT_POST_PROCESSORS);
        return new ImportConfig(postProcessors);
    }

    public ImportConfig() {
        this(Collections.emptyList());
    }

    public ImportConfig(String ... postProcessors) {
        this(Arrays.asList(postProcessors));
    }

    public ImportConfig(List<String> postProcessors) {
        this.postProcessors = Objects.requireNonNull(postProcessors);
    }

    public List<String> getPostProcessors() {
        return this.postProcessors;
    }

    public String toString() {
        return "{postProcessors=" + this.postProcessors + "}";
    }
}

