/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.TapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ValidationUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public interface TapChanger<C extends TapChanger<C, S>, S extends TapChangerStep<S>> {
    public int getLowTapPosition();

    public C setLowTapPosition(int var1);

    public int getHighTapPosition();

    public int getTapPosition();

    default public OptionalInt findTapPosition() {
        return OptionalInt.of(this.getTapPosition());
    }

    public C setTapPosition(int var1);

    default public C unsetTapPosition() {
        throw ValidationUtil.createUnsetMethodException();
    }

    public int getStepCount();

    public S getStep(int var1);

    public S getCurrentStep();

    default public OptionalInt getNeutralPosition() {
        return OptionalInt.empty();
    }

    default public Optional<S> getNeutralStep() {
        return Optional.empty();
    }

    public boolean isRegulating();

    public C setRegulating(boolean var1);

    public Terminal getRegulationTerminal();

    public C setRegulationTerminal(Terminal var1);

    default public double getTargetDeadband() {
        throw new UnsupportedOperationException();
    }

    default public C setTargetDeadband(double targetDeadband) {
        throw new UnsupportedOperationException();
    }

    public void remove();

    default public Map<Integer, S> getAllSteps() {
        HashMap<Integer, S> steps = new HashMap<Integer, S>();
        for (int i = this.getLowTapPosition(); i <= this.getHighTapPosition(); ++i) {
            steps.put(i, this.getStep(i));
        }
        return steps;
    }
}

