/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.TwoSides;

public enum ThreeSides {
    ONE(1, TwoSides.ONE),
    TWO(2, TwoSides.TWO),
    THREE(3, null);

    private final int num;
    private final TwoSides sideAsTwoSides;

    private ThreeSides(int num, TwoSides sideAsTwoSides) {
        this.num = num;
        this.sideAsTwoSides = sideAsTwoSides;
    }

    public int getNum() {
        return this.num;
    }

    public static ThreeSides valueOf(int num) {
        return switch (num) {
            case 1 -> ONE;
            case 2 -> TWO;
            case 3 -> THREE;
            default -> throw new PowsyblException("Cannot convert integer value " + num + " to ThreeSides.");
        };
    }

    public TwoSides toTwoSides() {
        if (this.sideAsTwoSides == null) {
            throw new PowsyblException("Cannot convert ThreeSides value " + this.name() + " as a TwoSides (" + TwoSides.ONE.name() + ", " + TwoSides.TWO.name() + ")");
        }
        return this.sideAsTwoSides;
    }
}

