/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class TerminalFinder {
    private final Comparator<Terminal> comparator;

    public static TerminalFinder getDefault() {
        return new TerminalFinder(TerminalFinder.getDefaultRules());
    }

    public TerminalFinder(Comparator<Terminal> comparator) {
        this.comparator = Objects.requireNonNull(comparator);
    }

    public TerminalFinder(List<Predicate<Terminal>> predicates) {
        this.comparator = TerminalFinder.getComparator(predicates);
    }

    public Optional<? extends Terminal> find(Iterable<? extends Terminal> terminals) {
        return this.find(StreamSupport.stream(terminals.spliterator(), false));
    }

    public Optional<? extends Terminal> find(Stream<? extends Terminal> terminals) {
        return terminals.max(this.comparator);
    }

    private static Comparator<Terminal> getComparator(List<Predicate<Terminal>> predicates) {
        Objects.requireNonNull(predicates);
        return (t1, t2) -> {
            if (t1.equals(t2)) {
                return 0;
            }
            for (Predicate p : predicates) {
                if (p.test(t1)) {
                    return 1;
                }
                if (!p.test(t2)) continue;
                return -1;
            }
            return 1;
        };
    }

    private static List<Predicate<Terminal>> getDefaultRules() {
        ArrayList<Predicate<Terminal>> rules = new ArrayList<Predicate<Terminal>>();
        rules.add(t -> t.getConnectable() instanceof BusbarSection);
        rules.add(t -> t.getConnectable() instanceof Injection);
        rules.add(t -> t.getConnectable() instanceof Branch);
        rules.add(t -> t.getConnectable() instanceof ThreeWindingsTransformer);
        rules.add(t -> t.getConnectable() instanceof HvdcConverterStation);
        rules.add(Objects::nonNull);
        return rules;
    }
}

