/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.util.LinkData;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class SV {
    private final double p;
    private final double q;
    private final double u;
    private final double a;
    private final TwoSides side;

    public SV(double p, double q, double u, double a, TwoSides side) {
        this.p = p;
        this.q = q;
        this.u = u;
        this.a = a;
        this.side = side;
    }

    public double getP() {
        return this.p;
    }

    public double getQ() {
        return this.q;
    }

    public double getU() {
        return this.u;
    }

    public double getA() {
        return this.a;
    }

    public TwoSides getSide() {
        return this.side;
    }

    public SV otherSide(double r, double x, double g1, double b1, double g2, double b2, double rho, double alpha) {
        return this.otherSide(r, x, g1, b1, g2, b2, rho, alpha, Double.NaN);
    }

    public SV otherSide(Line l) {
        double zb = l.getTerminal1().getVoltageLevel().getNominalV() * l.getTerminal2().getVoltageLevel().getNominalV();
        return this.otherSide(l.getR(), l.getX(), l.getG1(), l.getB1(), l.getG2(), l.getB2(), 1.0, 0.0, zb);
    }

    public SV otherSide(TieLine l) {
        double zb = l.getDanglingLine1().getTerminal().getVoltageLevel().getNominalV() * l.getDanglingLine2().getTerminal().getVoltageLevel().getNominalV();
        return this.otherSide(l.getR(), l.getX(), l.getG1(), l.getB1(), l.getG2(), l.getB2(), 1.0, 0.0, zb);
    }

    public SV otherSide(TwoWindingsTransformer twt) {
        double zbase = twt.getTerminal2().getVoltageLevel().getNominalV() * twt.getTerminal2().getVoltageLevel().getNominalV();
        return this.otherSide(SV.getR(twt), SV.getX(twt), SV.getG(twt), SV.getB(twt), 0.0, 0.0, SV.getRho(twt), SV.getAlpha(twt), zbase);
    }

    public SV otherSide(TwoWindingsTransformer twt, boolean splitShuntAdmittance) {
        if (splitShuntAdmittance) {
            double zb = twt.getTerminal2().getVoltageLevel().getNominalV() * twt.getTerminal2().getVoltageLevel().getNominalV();
            return this.otherSide(SV.getR(twt), SV.getX(twt), SV.getG(twt) * 0.5, SV.getB(twt) * 0.5, SV.getG(twt) * 0.5, SV.getB(twt) * 0.5, SV.getRho(twt), SV.getAlpha(twt), zb);
        }
        return this.otherSide(twt);
    }

    public SV otherSide(DanglingLine dl) {
        double zb = dl.getTerminal().getVoltageLevel().getNominalV() * dl.getTerminal().getVoltageLevel().getNominalV();
        return this.otherSide(dl.getR(), dl.getX(), dl.getG(), dl.getB(), 0.0, 0.0, 1.0, 0.0, zb);
    }

    public SV otherSide(DanglingLine dl, boolean splitShuntAdmittance) {
        if (splitShuntAdmittance) {
            double zb = dl.getTerminal().getVoltageLevel().getNominalV() * dl.getTerminal().getVoltageLevel().getNominalV();
            return this.otherSide(dl.getR(), dl.getX(), dl.getG() * 0.5, dl.getB() * 0.5, dl.getG() * 0.5, dl.getB() * 0.5, 1.0, 0.0, zb);
        }
        return this.otherSide(dl);
    }

    public double otherSideP(double r, double x, double g1, double b1, double g2, double b2, double rho, double alpha) {
        return this.otherSide(r, x, g1, b1, g2, b2, rho, alpha, Double.NaN).getP();
    }

    public double otherSideP(DanglingLine dl) {
        return this.otherSide(dl).getP();
    }

    public double otherSideP(DanglingLine dl, boolean splitShuntAdmittance) {
        return this.otherSide(dl, splitShuntAdmittance).getP();
    }

    public double otherSideQ(double r, double x, double g1, double b1, double g2, double b2, double rho, double alpha) {
        return this.otherSide(r, x, g1, b1, g2, b2, rho, alpha, Double.NaN).getQ();
    }

    public double otherSideQ(DanglingLine dl) {
        return this.otherSide(dl).getQ();
    }

    public double otherSideQ(DanglingLine dl, boolean splitShuntAdmittance) {
        return this.otherSide(dl, splitShuntAdmittance).getQ();
    }

    public double otherSideU(double r, double x, double g1, double b1, double g2, double b2, double rho, double alpha) {
        return this.otherSide(r, x, g1, b1, g2, b2, rho, alpha, Double.NaN).getU();
    }

    public double otherSideU(DanglingLine dl) {
        return this.otherSide(dl).getU();
    }

    public double otherSideU(DanglingLine dl, boolean splitShuntAdmittance) {
        return this.otherSide(dl, splitShuntAdmittance).getU();
    }

    public double otherSideA(double r, double x, double g1, double b1, double g2, double b2, double rho, double alpha) {
        return this.otherSide(r, x, g1, b1, g2, b2, rho, alpha, Double.NaN).getA();
    }

    public double otherSideA(DanglingLine dl) {
        return this.otherSide(dl).getA();
    }

    public double otherSideA(DanglingLine dl, boolean splitShuntAdmittance) {
        return this.otherSide(dl, splitShuntAdmittance).getA();
    }

    private static double getRho(TwoWindingsTransformer twt) {
        double rho = twt.getRatedU2() / twt.getRatedU1();
        if (twt.getRatioTapChanger() != null) {
            rho *= ((RatioTapChangerStep)twt.getRatioTapChanger().getCurrentStep()).getRho();
        }
        if (twt.getPhaseTapChanger() != null) {
            rho *= ((PhaseTapChangerStep)twt.getPhaseTapChanger().getCurrentStep()).getRho();
        }
        return rho;
    }

    private static double getAlpha(TwoWindingsTransformer twt) {
        double alpha = 0.0;
        if (twt.getPhaseTapChanger() != null) {
            alpha = ((PhaseTapChangerStep)twt.getPhaseTapChanger().getCurrentStep()).getAlpha();
        }
        return Math.toRadians(alpha);
    }

    private static double getR(TwoWindingsTransformer twt) {
        double r = twt.getR();
        if (twt.getRatioTapChanger() != null) {
            r *= 1.0 + ((RatioTapChangerStep)twt.getRatioTapChanger().getCurrentStep()).getR() / 100.0;
        }
        if (twt.getPhaseTapChanger() != null) {
            r *= 1.0 + ((PhaseTapChangerStep)twt.getPhaseTapChanger().getCurrentStep()).getR() / 100.0;
        }
        return r;
    }

    private static double getX(TwoWindingsTransformer twt) {
        double x = twt.getX();
        if (twt.getRatioTapChanger() != null) {
            x *= 1.0 + ((RatioTapChangerStep)twt.getRatioTapChanger().getCurrentStep()).getX() / 100.0;
        }
        if (twt.getPhaseTapChanger() != null) {
            x *= 1.0 + ((PhaseTapChangerStep)twt.getPhaseTapChanger().getCurrentStep()).getX() / 100.0;
        }
        return x;
    }

    private static double getG(TwoWindingsTransformer twt) {
        double g = twt.getG();
        if (twt.getRatioTapChanger() != null) {
            g *= 1.0 + ((RatioTapChangerStep)twt.getRatioTapChanger().getCurrentStep()).getG() / 100.0;
        }
        if (twt.getPhaseTapChanger() != null) {
            g *= 1.0 + ((PhaseTapChangerStep)twt.getPhaseTapChanger().getCurrentStep()).getG() / 100.0;
        }
        return g;
    }

    private static double getB(TwoWindingsTransformer twt) {
        double b = twt.getG();
        if (twt.getRatioTapChanger() != null) {
            b *= 1.0 + ((RatioTapChangerStep)twt.getRatioTapChanger().getCurrentStep()).getB() / 100.0;
        }
        if (twt.getPhaseTapChanger() != null) {
            b *= 1.0 + ((PhaseTapChangerStep)twt.getPhaseTapChanger().getCurrentStep()).getB() / 100.0;
        }
        return b;
    }

    public String toString() {
        return "p=" + this.p + ", q=" + this.q + ", u=" + this.u + ", a=" + this.a + ", end=" + this.side;
    }

    private boolean isAllDataForCalculatingOtherSide() {
        return !Double.isNaN(this.p) && !Double.isNaN(this.q) && !Double.isNaN(this.u) && !Double.isNaN(this.a);
    }

    private boolean isAllDataForCalculatingOtherSideDcApproximation(double zbase) {
        return !Double.isNaN(this.p) && !Double.isNaN(this.a) && !Double.isNaN(zbase);
    }

    private SV otherSide(double r, double x, double g1, double b1, double g2, double b2, double rho, double alpha, double zb) {
        if (this.isAllDataForCalculatingOtherSide()) {
            LinkData.BranchAdmittanceMatrix adm = LinkData.calculateBranchAdmittance(r, x, 1.0 / rho, -alpha, 1.0, 0.0, new Complex(g1, b1), new Complex(g2, b2));
            return this.otherSide(adm);
        }
        if (this.isAllDataForCalculatingOtherSideDcApproximation(zb)) {
            return this.otherSideDcApproximation(x, 1.0 / rho, -alpha, zb, true);
        }
        TwoSides otherSide = this.side == TwoSides.ONE ? TwoSides.TWO : TwoSides.ONE;
        return new SV(Double.NaN, Double.NaN, Double.NaN, Double.NaN, otherSide);
    }

    private SV otherSide(LinkData.BranchAdmittanceMatrix adm) {
        TwoSides otherSide;
        Complex s;
        Complex v;
        if (this.side == TwoSides.ONE) {
            Complex v1 = ComplexUtils.polar2Complex((double)this.u, (double)Math.toRadians(this.a));
            Complex s1 = new Complex(this.p, this.q);
            v = SV.voltageAtEnd2(adm, v1, s1);
            s = SV.flowAtEnd2(adm, v1, v);
            otherSide = TwoSides.TWO;
        } else {
            Complex v2 = ComplexUtils.polar2Complex((double)this.u, (double)Math.toRadians(this.a));
            Complex s2 = new Complex(this.p, this.q);
            v = SV.voltageAtEnd1(adm, v2, s2);
            s = SV.flowAtEnd1(adm, v, v2);
            otherSide = TwoSides.ONE;
        }
        return new SV(s.getReal(), s.getImaginary(), v.abs(), Math.toDegrees(v.getArgument()), otherSide);
    }

    private SV otherSideDcApproximation(double x, double ratio, double angle, double zb, boolean useRatio) {
        TwoSides otherSide;
        double aOtherSide;
        double b;
        double pOtherSide = -this.p;
        double xpu = x / zb;
        double d = b = useRatio ? 1.0 / (xpu * ratio) : 1.0 / xpu;
        if (this.side == TwoSides.ONE) {
            aOtherSide = Math.toDegrees(Math.toRadians(this.a) - angle - this.p / b);
            otherSide = TwoSides.TWO;
        } else {
            aOtherSide = Math.toDegrees(Math.toRadians(this.a) + angle - this.p / b);
            otherSide = TwoSides.ONE;
        }
        return new SV(pOtherSide, Double.NaN, Double.NaN, aOtherSide, otherSide);
    }

    private static Complex voltageAtEnd2(LinkData.BranchAdmittanceMatrix adm, Complex vEnd1, Complex sEnd1) {
        return sEnd1.conjugate().divide(vEnd1.conjugate()).subtract(adm.y11().multiply(vEnd1)).divide(adm.y12());
    }

    private static Complex voltageAtEnd1(LinkData.BranchAdmittanceMatrix adm, Complex vEnd2, Complex sEnd2) {
        return sEnd2.conjugate().divide(vEnd2.conjugate()).subtract(adm.y22().multiply(vEnd2)).divide(adm.y21());
    }

    private static Complex flowAtEnd1(LinkData.BranchAdmittanceMatrix adm, Complex vEnd1, Complex vEnd2) {
        return adm.y11().multiply(vEnd1).add(adm.y12().multiply(vEnd2)).multiply(vEnd1.conjugate()).conjugate();
    }

    private static Complex flowAtEnd2(LinkData.BranchAdmittanceMatrix adm, Complex vEnd1, Complex vEnd2) {
        return adm.y21().multiply(vEnd1).add(adm.y22().multiply(vEnd2)).multiply(vEnd2.conjugate()).conjugate();
    }
}

