/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.iidm.network.ExportersLoader;
import com.powsybl.iidm.network.ExportersServiceLoader;
import com.powsybl.iidm.network.Network;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;

public interface Exporter {
    public static Collection<String> getFormats(ExportersLoader loader) {
        Objects.requireNonNull(loader);
        return loader.loadExporters().stream().map(Exporter::getFormat).collect(Collectors.toSet());
    }

    public static Collection<String> getFormats() {
        return Exporter.getFormats(new ExportersServiceLoader());
    }

    public static Exporter find(ExportersLoader loader, String format) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(loader);
        for (Exporter e : loader.loadExporters()) {
            if (!format.equals(e.getFormat())) continue;
            return e;
        }
        return null;
    }

    public static Exporter find(String format) {
        return Exporter.find(new ExportersServiceLoader(), format);
    }

    public String getFormat();

    public String getComment();

    default public List<Parameter> getParameters() {
        return Collections.emptyList();
    }

    default public void export(Network network, Properties parameters, DataSource dataSource) {
        this.export(network, parameters, dataSource, Reporter.NO_OP);
    }

    default public void export(Network network, Properties parameters, DataSource dataSource, Reporter reporter) {
        this.export(network, parameters, dataSource);
    }
}

