/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.reporter.Reporter;
import com.powsybl.iidm.network.AbstractReporterContext;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public class MultiThreadReporterContext
extends AbstractReporterContext {
    private final ThreadLocal<Deque<Reporter>> reporters = ThreadLocal.withInitial(() -> {
        LinkedList<Reporter> deque = new LinkedList<Reporter>();
        deque.push(Reporter.NO_OP);
        return deque;
    });

    public MultiThreadReporterContext() {
    }

    public MultiThreadReporterContext(AbstractReporterContext reporterContext) {
        this();
        this.copyReporters(reporterContext);
    }

    @Override
    public Reporter getReporter() {
        return this.reporters.get().peek();
    }

    @Override
    public void pushReporter(Reporter reporter) {
        this.reporters.get().push(reporter);
    }

    @Override
    public Reporter popReporter() {
        Reporter popped = this.reporters.get().pop();
        if (this.reporters.get().isEmpty()) {
            this.reporters.get().push(Reporter.NO_OP);
        }
        return popped;
    }

    public void close() {
        this.reporters.remove();
    }

    @Override
    protected Iterator<Reporter> descendingIterator() {
        return this.reporters.get().descendingIterator();
    }
}

