/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.PhaseTapChangerHolder;
import com.powsybl.iidm.network.RatioTapChangerHolder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface ThreeWindingsTransformer
extends Connectable<ThreeWindingsTransformer> {
    public Terminal getTerminal(ThreeSides var1);

    public ThreeSides getSide(Terminal var1);

    public Optional<Substation> getSubstation();

    default public Substation getNullableSubstation() {
        return this.getSubstation().orElse(null);
    }

    public Leg getLeg1();

    public Leg getLeg2();

    public Leg getLeg3();

    default public Leg getLeg(ThreeSides side) {
        switch (side) {
            case ONE: {
                return this.getLeg1();
            }
            case TWO: {
                return this.getLeg2();
            }
            case THREE: {
                return this.getLeg3();
            }
        }
        throw new PowsyblException("Can't get leg from side. Unsupported Side \"" + side + "\"");
    }

    default public Stream<Leg> getLegStream() {
        return Stream.of(this.getLeg1(), this.getLeg2(), this.getLeg3());
    }

    default public List<Leg> getLegs() {
        return Arrays.asList(this.getLeg1(), this.getLeg2(), this.getLeg3());
    }

    public double getRatedU0();

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.THREE_WINDINGS_TRANSFORMER;
    }

    public boolean isOverloaded();

    public boolean isOverloaded(float var1);

    public int getOverloadDuration();

    public boolean checkPermanentLimit(ThreeSides var1, float var2, LimitType var3);

    public boolean checkPermanentLimit(ThreeSides var1, LimitType var2);

    public boolean checkPermanentLimit1(float var1, LimitType var2);

    public boolean checkPermanentLimit1(LimitType var1);

    public boolean checkPermanentLimit2(float var1, LimitType var2);

    public boolean checkPermanentLimit2(LimitType var1);

    public boolean checkPermanentLimit3(float var1, LimitType var2);

    public boolean checkPermanentLimit3(LimitType var1);

    public Overload checkTemporaryLimits(ThreeSides var1, float var2, LimitType var3);

    public Overload checkTemporaryLimits(ThreeSides var1, LimitType var2);

    public Overload checkTemporaryLimits1(float var1, LimitType var2);

    public Overload checkTemporaryLimits1(LimitType var1);

    public Overload checkTemporaryLimits2(float var1, LimitType var2);

    public Overload checkTemporaryLimits2(LimitType var1);

    public Overload checkTemporaryLimits3(float var1, LimitType var2);

    public Overload checkTemporaryLimits3(LimitType var1);

    public static interface Leg
    extends RatioTapChangerHolder,
    PhaseTapChangerHolder,
    FlowsLimitsHolder {
        public Terminal getTerminal();

        public double getR();

        public Leg setR(double var1);

        public double getX();

        public Leg setX(double var1);

        public double getG();

        public Leg setG(double var1);

        public double getB();

        public Leg setB(double var1);

        public double getRatedU();

        public Leg setRatedU(double var1);

        default public double getRatedS() {
            throw new UnsupportedOperationException();
        }

        default public Leg setRatedS(double ratedS) {
            throw new UnsupportedOperationException();
        }

        public ThreeSides getSide();

        public Optional<? extends LoadingLimits> getLimits(LimitType var1);
    }
}

