/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.commons.PowsyblException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.Pseudograph;

public class ContainersMapping {
    private final Map<Integer, String> busNumToVoltageLevelId = new HashMap<Integer, String>();
    private final Map<String, Set<Integer>> voltageLevelIdToBusNums = new HashMap<String, Set<Integer>>();
    private final Map<String, String> voltageLevelIdToSubstationId = new HashMap<String, String>();

    public String getVoltageLevelId(int num) {
        String voltageLevelId = this.busNumToVoltageLevelId.get(num);
        if (voltageLevelId == null) {
            throw new PowsyblException("Bus " + num + " not found");
        }
        return voltageLevelId;
    }

    public String getSubstationId(String voltageLevelId) {
        String substationId = this.voltageLevelIdToSubstationId.get(voltageLevelId);
        if (substationId == null) {
            throw new PowsyblException("Voltage level '" + voltageLevelId + "' not found");
        }
        return substationId;
    }

    @Deprecated(since="4.9.2")
    public static <N, B> ContainersMapping create(List<N> buses, List<B> branches, ToIntFunction<N> busToNum, ToIntFunction<B> branchToNum1, ToIntFunction<B> branchToNum2, ToIntFunction<B> branchToNum3, ToDoubleFunction<B> branchToResistance, ToDoubleFunction<B> branchToReactance, Predicate<B> branchToIsTransformer, Function<Set<Integer>, String> busesToVoltageLevelId, IntFunction<String> substationNumToId) {
        throw new PowsyblException("Deprecated. Not used anymore");
    }

    public static <N, B> ContainersMapping create(List<N> buses, List<B> branches, ToIntFunction<N> busToNum, ToIntFunction<B> branchToNum1, ToIntFunction<B> branchToNum2, Predicate<B> branchToIsZeroImpedance, Predicate<B> branchToIsTransformer, ToDoubleFunction<Integer> busToNominalVoltage, Function<Set<Integer>, String> busesToVoltageLevelId, Function<Set<Integer>, String> busesToSubstationId) {
        Objects.requireNonNull(buses);
        Objects.requireNonNull(branches);
        Objects.requireNonNull(busToNum);
        Objects.requireNonNull(branchToNum1);
        Objects.requireNonNull(branchToNum2);
        Objects.requireNonNull(branchToIsTransformer);
        Objects.requireNonNull(branchToIsZeroImpedance);
        Objects.requireNonNull(busesToVoltageLevelId);
        Objects.requireNonNull(busesToSubstationId);
        ContainersMapping containersMapping = new ContainersMapping();
        Pseudograph sGraph = new Pseudograph(null, null, false);
        for (N bus : buses) {
            sGraph.addVertex((Object)busToNum.applyAsInt(bus));
        }
        for (Object branch : branches) {
            if (!branchToIsZeroImpedance.test(branch) && !branchToIsTransformer.test(branch)) continue;
            sGraph.addEdge((Object)branchToNum1.applyAsInt(branch), (Object)branchToNum2.applyAsInt(branch), branch);
        }
        for (Set busNums : new ConnectivityInspector((Graph)sGraph).connectedSets()) {
            ContainersMapping.createAndMapSubstationAndVoltageLevelsInside(branchToNum1, branchToNum2, branchToIsZeroImpedance, busToNominalVoltage, busesToVoltageLevelId, busesToSubstationId, busNums, sGraph, containersMapping);
        }
        return containersMapping;
    }

    private static <B> void createAndMapSubstationAndVoltageLevelsInside(ToIntFunction<B> branchToNum1, ToIntFunction<B> branchToNum2, Predicate<B> branchToIsZeroImpedance, ToDoubleFunction<Integer> busToNominalVoltage, Function<Set<Integer>, String> busesToVoltageLevelId, Function<Set<Integer>, String> busesToSubstationId, Set<Integer> substationBusNums, Graph<Integer, B> sGraph, ContainersMapping containersMapping) {
        String substationId = busesToSubstationId.apply(substationBusNums);
        HashSet zeroImpedanceBranchesInsideSubstation = new HashSet();
        substationBusNums.forEach(bus -> zeroImpedanceBranchesInsideSubstation.addAll(sGraph.edgesOf(bus).stream().filter(branchToIsZeroImpedance::test).collect(Collectors.toSet())));
        Pseudograph vlGraph = new Pseudograph(Object.class);
        Iterator<Integer> iter = substationBusNums.iterator();
        while (iter.hasNext()) {
            vlGraph.addVertex((Object)iter.next());
        }
        zeroImpedanceBranchesInsideSubstation.forEach(arg_0 -> ContainersMapping.lambda$createAndMapSubstationAndVoltageLevelsInside$1((Graph)vlGraph, branchToNum1, branchToNum2, arg_0));
        if (busToNominalVoltage == null) {
            new ConnectivityInspector((Graph)vlGraph).connectedSets().forEach(voltageLevelIds -> ContainersMapping.mapSubstationAndVoltageLevel(busesToVoltageLevelId, substationId, voltageLevelIds, containersMapping));
        } else {
            HashMap vls = new HashMap();
            new ConnectivityInspector((Graph)vlGraph).connectedSets().forEach(voltageLevelIds -> vls.merge(ContainersMapping.getNominalVoltage(voltageLevelIds, busToNominalVoltage), voltageLevelIds, ContainersMapping::unionSet));
            vls.values().forEach(voltageLevelIds -> ContainersMapping.mapSubstationAndVoltageLevel(busesToVoltageLevelId, substationId, voltageLevelIds, containersMapping));
        }
    }

    private static String getNominalVoltage(Set<Integer> voltageLevelIds, ToDoubleFunction<Integer> busToVoltageLevelNominal) {
        Objects.requireNonNull(busToVoltageLevelNominal);
        if (voltageLevelIds.isEmpty()) {
            throw new PowsyblException("Unexpected empty connected set");
        }
        return String.valueOf(busToVoltageLevelNominal.applyAsDouble(voltageLevelIds.iterator().next()));
    }

    private static Set<Integer> unionSet(Set<Integer> set1, Set<Integer> set2) {
        HashSet<Integer> unionSet = new HashSet<Integer>(set1);
        unionSet.addAll(set2);
        return unionSet;
    }

    private static void mapSubstationAndVoltageLevel(Function<Set<Integer>, String> busesToVoltageLevelId, String substationId, Set<Integer> busNums, ContainersMapping containersMapping) {
        String voltageLevelId = busesToVoltageLevelId.apply(busNums);
        containersMapping.voltageLevelIdToBusNums.put(voltageLevelId, busNums);
        for (int busNum : busNums) {
            containersMapping.busNumToVoltageLevelId.put(busNum, voltageLevelId);
        }
        containersMapping.voltageLevelIdToSubstationId.put(voltageLevelId, substationId);
    }

    private static /* synthetic */ void lambda$createAndMapSubstationAndVoltageLevelsInside$1(Graph vlGraph, ToIntFunction branchToNum1, ToIntFunction branchToNum2, Object branch) {
        vlGraph.addEdge((Object)branchToNum1.applyAsInt(branch), (Object)branchToNum2.applyAsInt(branch));
    }
}

