/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Container;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Ground;
import com.powsybl.iidm.network.GroundAdder;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.network.util.ShortIdDictionary;
import com.powsybl.math.graph.TraverseResult;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface VoltageLevel
extends Container<VoltageLevel> {
    public Optional<Substation> getSubstation();

    default public Substation getNullableSubstation() {
        return this.getSubstation().orElse(null);
    }

    public double getNominalV();

    public VoltageLevel setNominalV(double var1);

    public double getLowVoltageLimit();

    public VoltageLevel setLowVoltageLimit(double var1);

    public double getHighVoltageLimit();

    public VoltageLevel setHighVoltageLimit(double var1);

    public <T extends Connectable> T getConnectable(String var1, Class<T> var2);

    public <T extends Connectable> Iterable<T> getConnectables(Class<T> var1);

    public <T extends Connectable> Stream<T> getConnectableStream(Class<T> var1);

    public <T extends Connectable> int getConnectableCount(Class<T> var1);

    public Iterable<Connectable> getConnectables();

    public Stream<Connectable> getConnectableStream();

    public int getConnectableCount();

    public GeneratorAdder newGenerator();

    public Iterable<Generator> getGenerators();

    public Stream<Generator> getGeneratorStream();

    public int getGeneratorCount();

    public BatteryAdder newBattery();

    public Iterable<Battery> getBatteries();

    public Stream<Battery> getBatteryStream();

    public int getBatteryCount();

    public LoadAdder newLoad();

    public Iterable<Load> getLoads();

    public Stream<Load> getLoadStream();

    public Iterable<Switch> getSwitches();

    public int getSwitchCount();

    public int getLoadCount();

    public ShuntCompensatorAdder newShuntCompensator();

    public Iterable<ShuntCompensator> getShuntCompensators();

    public Stream<ShuntCompensator> getShuntCompensatorStream();

    public int getShuntCompensatorCount();

    public DanglingLineAdder newDanglingLine();

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter var1);

    default public Iterable<DanglingLine> getDanglingLines() {
        return this.getDanglingLines(DanglingLineFilter.ALL);
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter var1);

    default public Stream<DanglingLine> getDanglingLineStream() {
        return this.getDanglingLineStream(DanglingLineFilter.ALL);
    }

    public int getDanglingLineCount();

    public StaticVarCompensatorAdder newStaticVarCompensator();

    public Iterable<StaticVarCompensator> getStaticVarCompensators();

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream();

    public int getStaticVarCompensatorCount();

    public VscConverterStationAdder newVscConverterStation();

    public Iterable<VscConverterStation> getVscConverterStations();

    public Stream<VscConverterStation> getVscConverterStationStream();

    public int getVscConverterStationCount();

    public LccConverterStationAdder newLccConverterStation();

    public Iterable<LccConverterStation> getLccConverterStations();

    public Stream<LccConverterStation> getLccConverterStationStream();

    public int getLccConverterStationCount();

    public Iterable<Line> getLines();

    public Stream<Line> getLineStream();

    public int getLineCount();

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers();

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream();

    public int getTwoWindingsTransformerCount();

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers();

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream();

    public int getThreeWindingsTransformerCount();

    public GroundAdder newGround();

    public Iterable<Ground> getGrounds();

    public Stream<Ground> getGroundStream();

    public int getGroundCount();

    default public void remove() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void visitEquipments(TopologyVisitor var1);

    public TopologyKind getTopologyKind();

    public NodeBreakerView getNodeBreakerView();

    public BusBreakerView getBusBreakerView();

    public BusView getBusView();

    public void printTopology();

    public void printTopology(PrintStream var1, ShortIdDictionary var2);

    public void exportTopology(Path var1) throws IOException;

    public void exportTopology(Writer var1, Random var2) throws IOException;

    public void exportTopology(Writer var1) throws IOException;

    @Override
    default public IdentifiableType getType() {
        return IdentifiableType.VOLTAGE_LEVEL;
    }

    public static interface BusView {
        public Iterable<Bus> getBuses();

        public Stream<Bus> getBusStream();

        public Bus getBus(String var1);

        public Bus getMergedBus(String var1);
    }

    public static interface BusBreakerView {
        public Iterable<Bus> getBuses();

        public Stream<Bus> getBusStream();

        public int getBusCount();

        public Bus getBus(String var1);

        public BusAdder newBus();

        public void removeBus(String var1);

        public void removeAllBuses();

        public Iterable<Switch> getSwitches();

        public Stream<Switch> getSwitchStream();

        public int getSwitchCount();

        public void removeSwitch(String var1);

        public void removeAllSwitches();

        public Bus getBus1(String var1);

        public Bus getBus2(String var1);

        default public Collection<Bus> getBusesFromBusViewBusId(String mergedBusId) {
            return this.getBusStreamFromBusViewBusId(mergedBusId).collect(Collectors.toSet());
        }

        default public Stream<Bus> getBusStreamFromBusViewBusId(String mergedBusId) {
            VoltageLevel vl = this.getBusStream().flatMap(Bus::getConnectedTerminalStream).map(Terminal::getVoltageLevel).findFirst().orElseThrow(() -> new PowsyblException("No connected bus is found"));
            Bus mergedBus = vl.getBusView().getBus(mergedBusId);
            if (mergedBus == null) {
                throw new PowsyblException("Bus " + mergedBusId + " is not found in Bus-branch view of voltage level " + vl.getId());
            }
            return mergedBus.getConnectedTerminalStream().map(t -> t.getBusBreakerView().getBus()).distinct();
        }

        public Switch getSwitch(String var1);

        public SwitchAdder newSwitch();

        public void traverse(Bus var1, TopologyTraverser var2);

        public static interface TopologyTraverser {
            public TraverseResult traverse(Bus var1, Switch var2, Bus var3);
        }

        public static interface SwitchAdder
        extends IdentifiableAdder<Switch, SwitchAdder> {
            public SwitchAdder setBus1(String var1);

            public SwitchAdder setBus2(String var1);

            public SwitchAdder setOpen(boolean var1);

            @Override
            public Switch add();
        }
    }

    public static interface NodeBreakerView {
        default public double getFictitiousP0(int node) {
            return 0.0;
        }

        default public NodeBreakerView setFictitiousP0(int node, double p0) {
            return this;
        }

        default public double getFictitiousQ0(int node) {
            return 0.0;
        }

        default public NodeBreakerView setFictitiousQ0(int node, double q0) {
            return this;
        }

        default public int getMaximumNodeIndex() {
            throw new UnsupportedOperationException();
        }

        public int[] getNodes();

        public SwitchAdder newSwitch();

        public InternalConnectionAdder newInternalConnection();

        public int getInternalConnectionCount();

        public Iterable<InternalConnection> getInternalConnections();

        public Stream<InternalConnection> getInternalConnectionStream();

        default public void removeInternalConnections(int node1, int node2) {
            throw new UnsupportedOperationException();
        }

        public SwitchAdder newBreaker();

        public SwitchAdder newDisconnector();

        public int getNode1(String var1);

        public int getNode2(String var1);

        public Terminal getTerminal(int var1);

        default public Optional<Terminal> getOptionalTerminal(int node) {
            throw new UnsupportedOperationException();
        }

        public Stream<Switch> getSwitchStream(int var1);

        public List<Switch> getSwitches(int var1);

        public IntStream getNodeInternalConnectedToStream(int var1);

        public List<Integer> getNodesInternalConnectedTo(int var1);

        default public boolean hasAttachedEquipment(int node) {
            throw new UnsupportedOperationException();
        }

        public Terminal getTerminal1(String var1);

        public Terminal getTerminal2(String var1);

        public Switch getSwitch(String var1);

        public Iterable<Switch> getSwitches();

        public Stream<Switch> getSwitchStream();

        public int getSwitchCount();

        public void removeSwitch(String var1);

        public BusbarSectionAdder newBusbarSection();

        public Iterable<BusbarSection> getBusbarSections();

        public Stream<BusbarSection> getBusbarSectionStream();

        public int getBusbarSectionCount();

        public BusbarSection getBusbarSection(String var1);

        public void traverse(int var1, TopologyTraverser var2);

        public void traverse(int[] var1, TopologyTraverser var2);

        public static interface TopologyTraverser {
            public TraverseResult traverse(int var1, Switch var2, int var3);
        }

        public static interface InternalConnection {
            public int getNode1();

            public int getNode2();
        }

        public static interface InternalConnectionAdder {
            public InternalConnectionAdder setNode1(int var1);

            public InternalConnectionAdder setNode2(int var1);

            public void add();
        }

        public static interface SwitchAdder
        extends IdentifiableAdder<Switch, SwitchAdder> {
            public SwitchAdder setNode1(int var1);

            public SwitchAdder setNode2(int var1);

            public SwitchAdder setKind(SwitchKind var1);

            public SwitchAdder setKind(String var1);

            public SwitchAdder setOpen(boolean var1);

            public SwitchAdder setRetained(boolean var1);

            @Override
            public Switch add();
        }
    }
}

