/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.util.OverloadImpl;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public final class LimitViolationUtils {
    public static final String PERMANENT_LIMIT_NAME = "permanent";

    private LimitViolationUtils() {
    }

    public static Overload checkTemporaryLimits(Branch<?> branch, TwoSides side, double limitReductionValue, double i, LimitType type) {
        Objects.requireNonNull(branch);
        Objects.requireNonNull(side);
        return LimitViolationUtils.getLimits(branch, side, type).map(limits -> LimitViolationUtils.getOverload(limits, i, limitReductionValue)).orElse(null);
    }

    public static Overload checkTemporaryLimits(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, double i, LimitType type) {
        Objects.requireNonNull(transformer);
        Objects.requireNonNull(side);
        return LimitViolationUtils.getLimits(transformer, side, type).map(limits -> LimitViolationUtils.getOverload(limits, i, limitReductionValue)).orElse(null);
    }

    private static OverloadImpl getOverload(LoadingLimits limits, double i, double limitReductionValue) {
        double permanentLimit = limits.getPermanentLimit();
        if (Double.isNaN(i) || Double.isNaN(permanentLimit)) {
            return null;
        }
        Collection<LoadingLimits.TemporaryLimit> temporaryLimits = limits.getTemporaryLimits();
        String previousLimitName = PERMANENT_LIMIT_NAME;
        double previousLimit = permanentLimit;
        for (LoadingLimits.TemporaryLimit tl : temporaryLimits) {
            if (i >= previousLimit * limitReductionValue && i < tl.getValue() * limitReductionValue) {
                return new OverloadImpl(tl, previousLimitName, previousLimit);
            }
            previousLimitName = tl.getName();
            previousLimit = tl.getValue();
        }
        return null;
    }

    private static boolean checkPermanentLimitIfAny(LoadingLimits limits, double i, double limitReductionValue) {
        double permanentLimit = limits.getPermanentLimit();
        if (Double.isNaN(i) || Double.isNaN(permanentLimit)) {
            return false;
        }
        return i >= permanentLimit * limitReductionValue;
    }

    public static boolean checkPermanentLimit(Branch<?> branch, TwoSides side, double limitReductionValue, double i, LimitType type) {
        return LimitViolationUtils.getLimits(branch, side, type).map(l -> LimitViolationUtils.checkPermanentLimitIfAny(l, i, limitReductionValue)).orElse(false);
    }

    public static boolean checkPermanentLimit(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, double i, LimitType type) {
        return LimitViolationUtils.getLimits(transformer, side, type).map(l -> LimitViolationUtils.checkPermanentLimitIfAny(l, i, limitReductionValue)).orElse(false);
    }

    public static double getValueForLimit(Terminal t, LimitType type) {
        return switch (type) {
            case LimitType.ACTIVE_POWER -> t.getP();
            case LimitType.APPARENT_POWER -> Math.sqrt(t.getP() * t.getP() + t.getQ() * t.getQ());
            case LimitType.CURRENT -> t.getI();
            default -> throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
        };
    }

    public static boolean checkPermanentLimit(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit(transformer, side, limitReductionValue, LimitViolationUtils.getValueForLimit(transformer.getTerminal(side), type), type);
    }

    public static Overload checkTemporaryLimits(ThreeWindingsTransformer transformer, ThreeSides side, double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits(transformer, side, limitReductionValue, LimitViolationUtils.getValueForLimit(transformer.getTerminal(side), type), type);
    }

    private static Optional<? extends LoadingLimits> getLimits(Branch<?> branch, TwoSides side, LimitType type) {
        return branch.getLimits(type, side);
    }

    private static Optional<? extends LoadingLimits> getLimits(ThreeWindingsTransformer transformer, ThreeSides side, LimitType type) {
        return transformer.getLeg(side).getLimits(type);
    }
}

