/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.util;

import com.google.common.collect.Sets;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.util.DanglingLineData;
import com.powsybl.iidm.network.util.LinkData;
import com.powsybl.iidm.network.util.TieLineReports;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TieLineUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TieLineUtil.class);
    public static final String NO_TIE_LINE_MESSAGE = "No tie line automatically created, tie lines must be created by hand.";

    private TieLineUtil() {
    }

    public static String buildMergedId(String id1, String id2) {
        if (id1.compareTo(id2) < 0) {
            return id1 + " + " + id2;
        }
        if (id1.compareTo(id2) > 0) {
            return id2 + " + " + id1;
        }
        return id1;
    }

    public static String buildMergedName(String id1, String id2, String name1, String name2) {
        if (name1 == null) {
            return name2;
        }
        if (name2 == null) {
            return name1;
        }
        if (name1.compareTo(name2) == 0) {
            return name1;
        }
        if (id1.compareTo(id2) < 0) {
            return name1 + " + " + name2;
        }
        if (id1.compareTo(id2) > 0) {
            return name2 + " + " + name1;
        }
        if (name1.compareTo(name2) < 0) {
            return name1 + " + " + name2;
        }
        return name2 + " + " + name1;
    }

    public static void mergeProperties(DanglingLine dl1, DanglingLine dl2, Properties properties) {
        TieLineUtil.mergeProperties(dl1, dl2, properties, ReportNode.NO_OP);
    }

    public static void mergeProperties(DanglingLine dl1, DanglingLine dl2, Properties properties, ReportNode reportNode) {
        Set<String> dl1Properties = dl1.getPropertyNames();
        Set<String> dl2Properties = dl2.getPropertyNames();
        Sets.SetView commonProperties = Sets.intersection(dl1Properties, dl2Properties);
        Sets.difference(dl1Properties, (Set)commonProperties).forEach(prop -> properties.setProperty((String)prop, dl1.getProperty((String)prop)));
        Sets.difference(dl2Properties, (Set)commonProperties).forEach(prop -> properties.setProperty((String)prop, dl2.getProperty((String)prop)));
        commonProperties.forEach(prop -> {
            if (dl1.getProperty((String)prop).equals(dl2.getProperty((String)prop))) {
                properties.setProperty((String)prop, dl1.getProperty((String)prop));
            } else if (dl1.getProperty((String)prop).isEmpty()) {
                LOGGER.debug("Inconsistencies of property '{}' between both sides of merged line. Side 1 is empty, keeping side 2 value '{}'", prop, (Object)dl2.getProperty((String)prop));
                TieLineReports.propertyOnlyOnOneSide(reportNode, prop, dl2.getProperty((String)prop), 1, dl1.getId(), dl2.getId());
                properties.setProperty((String)prop, dl2.getProperty((String)prop));
            } else if (dl2.getProperty((String)prop).isEmpty()) {
                LOGGER.debug("Inconsistencies of property '{}' between both sides of merged line. Side 2 is empty, keeping side 1 value '{}'", prop, (Object)dl1.getProperty((String)prop));
                TieLineReports.propertyOnlyOnOneSide(reportNode, prop, dl1.getProperty((String)prop), 2, dl1.getId(), dl2.getId());
                properties.setProperty((String)prop, dl1.getProperty((String)prop));
            } else {
                LOGGER.debug("Inconsistencies of property '{}' between both sides of merged line. '{}' on side 1 and '{}' on side 2. Removing the property of merged line", new Object[]{prop, dl1.getProperty((String)prop), dl2.getProperty((String)prop)});
                TieLineReports.inconsistentPropertyValues(reportNode, prop, dl1.getProperty((String)prop), dl2.getProperty((String)prop), dl1.getId(), dl2.getId());
            }
        });
        dl1Properties.forEach(prop -> properties.setProperty(prop + "_1", dl1.getProperty((String)prop)));
        dl2Properties.forEach(prop -> properties.setProperty(prop + "_2", dl2.getProperty((String)prop)));
    }

    public static void mergeIdenticalAliases(DanglingLine dl1, DanglingLine dl2, Map<String, String> aliases) {
        TieLineUtil.mergeIdenticalAliases(dl1, dl2, aliases, ReportNode.NO_OP);
    }

    public static void mergeIdenticalAliases(DanglingLine dl1, DanglingLine dl2, Map<String, String> aliases, ReportNode reportNode) {
        for (String alias2 : dl1.getAliases()) {
            if (!dl2.getAliases().contains(alias2)) continue;
            LOGGER.debug("Alias '{}' is found in dangling lines '{}' and '{}'. It is moved to their new tie line.", new Object[]{alias2, dl1.getId(), dl2.getId()});
            TieLineReports.moveCommonAliases(reportNode, alias2, dl1.getId(), dl2.getId());
            String type1 = dl1.getAliasType(alias2).orElse("");
            String type2 = dl2.getAliasType(alias2).orElse("");
            if (type1.equals(type2)) {
                aliases.put(alias2, type1);
                continue;
            }
            LOGGER.warn("Inconsistencies found for alias '{}' type in dangling lines '{}' and '{}'. Type is lost.", new Object[]{alias2, dl1.getId(), dl2.getId()});
            TieLineReports.inconsistentAliasTypes(reportNode, alias2, type1, type2, dl1.getId(), dl2.getId());
            aliases.put(alias2, "");
        }
        aliases.keySet().forEach(alias -> {
            dl1.removeAlias((String)alias);
            dl2.removeAlias((String)alias);
        });
    }

    public static void mergeDifferentAliases(DanglingLine dl1, DanglingLine dl2, Map<String, String> aliases, ReportNode reportNode) {
        for (String alias2 : dl1.getAliases()) {
            if (dl2.getAliases().contains(alias2)) continue;
            aliases.put(alias2, dl1.getAliasType(alias2).orElse(""));
        }
        for (String alias2 : dl2.getAliases()) {
            if (dl1.getAliases().contains(alias2)) continue;
            Object type = dl2.getAliasType(alias2).orElse("");
            if (!((String)type).isEmpty() && aliases.containsValue(type)) {
                String tmpType = type;
                String alias1 = aliases.entrySet().stream().filter(e -> tmpType.equals(e.getValue())).map(Map.Entry::getKey).findFirst().orElseThrow(IllegalStateException::new);
                aliases.put(alias1, (String)type + "_1");
                LOGGER.warn("Inconsistencies found for alias type '{}'('{}' for '{}' and '{}' for '{}'). Types are respectively renamed as '{}_1' and '{}_2'.", new Object[]{type, alias1, dl1.getId(), alias2, dl2.getId(), type, type});
                TieLineReports.inconsistentAliasValues(reportNode, alias1, alias2, (String)type, dl1.getId(), dl2.getId());
                type = (String)type + "_2";
            }
            aliases.put(alias2, (String)type);
        }
        aliases.keySet().forEach(alias -> {
            if (dl1.getAliases().contains(alias)) {
                dl1.removeAlias((String)alias);
            }
            if (dl2.getAliases().contains(alias)) {
                dl2.removeAlias((String)alias);
            }
        });
    }

    public static List<DanglingLine> findCandidateDanglingLines(Network network, Predicate<String> logPairingKey) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(logPairingKey);
        ArrayList<DanglingLine> candidates = new ArrayList<DanglingLine>();
        HashSet pairingKeys = new HashSet();
        HashMap connectedByPairingKey = new HashMap();
        HashMap disconnectedByPairingKey = new HashMap();
        network.getDanglingLines(DanglingLineFilter.UNPAIRED).forEach(dl -> {
            String pairingKey = dl.getPairingKey();
            Map mapToUpdate = dl.getTerminal().isConnected() ? connectedByPairingKey : disconnectedByPairingKey;
            mapToUpdate.computeIfAbsent(pairingKey, k -> new ArrayList()).add(dl);
            pairingKeys.add(pairingKey);
        });
        for (String pairingKey : pairingKeys) {
            DanglingLine dl2;
            boolean doLog = logPairingKey.test(pairingKey);
            List connected = Optional.ofNullable((List)connectedByPairingKey.get(pairingKey)).orElse(Collections.emptyList());
            List disconnected = Optional.ofNullable((List)disconnectedByPairingKey.get(pairingKey)).orElse(Collections.emptyList());
            if (connected.isEmpty()) {
                dl2 = (DanglingLine)disconnected.get(0);
                if (disconnected.size() == 1) {
                    candidates.add(dl2);
                    continue;
                }
                if (!doLog) continue;
                LOGGER.warn("Several disconnected dangling lines {} (and no connected one) of the same subnetwork are candidate for merging for pairing key '{}'. No tie line automatically created, tie lines must be created by hand.", disconnected.stream().map(Identifiable::getId).toList(), (Object)pairingKey);
                continue;
            }
            if (connected.size() == 1) {
                dl2 = (DanglingLine)connected.get(0);
                candidates.add(dl2);
                if (disconnected.isEmpty() || !doLog) continue;
                LOGGER.warn("Several dangling lines {} of the same subnetwork are candidate for merging for pairing key '{}'. Only '{}' is considered (the only connected one)", new Object[]{Stream.concat(Stream.of(dl2.getId()), disconnected.stream().map(Identifiable::getId)).collect(Collectors.toList()), pairingKey, dl2.getId()});
                continue;
            }
            if (!doLog) continue;
            LOGGER.warn("Several connected dangling lines {} of the same subnetwork are candidate for merging for pairing key '{}'. No tie line automatically created, tie lines must be created by hand.", connected.stream().map(Identifiable::getId).toList(), (Object)pairingKey);
        }
        return candidates;
    }

    public static void findAndAssociateDanglingLines(DanglingLine candidateDanglingLine, Function<String, List<DanglingLine>> getDanglingLinesByPairingKey, BiConsumer<DanglingLine, DanglingLine> associateDanglingLines) {
        Objects.requireNonNull(candidateDanglingLine);
        Objects.requireNonNull(getDanglingLinesByPairingKey);
        Objects.requireNonNull(associateDanglingLines);
        if (candidateDanglingLine.getPairingKey() != null) {
            if (candidateDanglingLine.getNetwork().getDanglingLineStream(DanglingLineFilter.UNPAIRED).filter(d -> d != candidateDanglingLine).filter(d -> candidateDanglingLine.getPairingKey().equals(d.getPairingKey())).anyMatch(d -> d.getTerminal().isConnected())) {
                return;
            }
            List<DanglingLine> dls = getDanglingLinesByPairingKey.apply(candidateDanglingLine.getPairingKey());
            if (dls != null) {
                if (dls.size() == 1) {
                    associateDanglingLines.accept(dls.get(0), candidateDanglingLine);
                }
                if (dls.size() > 1) {
                    List connectedDls = dls.stream().filter(dl -> dl.getTerminal().isConnected()).collect(Collectors.toList());
                    if (connectedDls.size() == 1) {
                        LOGGER.warn("Several dangling lines {} of the same subnetwork are candidate for merging for pairing key '{}'. Tie line automatically created using the only connected one '{}'.", new Object[]{dls.stream().map(Identifiable::getId).collect(Collectors.toList()), ((DanglingLine)connectedDls.get(0)).getPairingKey(), ((DanglingLine)connectedDls.get(0)).getId()});
                        associateDanglingLines.accept((DanglingLine)connectedDls.get(0), candidateDanglingLine);
                    } else {
                        String status = connectedDls.size() > 1 ? "connected" : "disconnected";
                        LOGGER.warn("Several {} dangling lines {} of the same subnetwork are candidate for merging for pairing key '{}'. No tie line automatically created, tie lines must be created by hand.", new Object[]{status, connectedDls.stream().map(Identifiable::getId).collect(Collectors.toList()), ((DanglingLine)connectedDls.get(0)).getPairingKey()});
                    }
                }
            }
        }
    }

    public static double getR(DanglingLine dl1, DanglingLine dl2) {
        LinkData.BranchAdmittanceMatrix adm = TieLineUtil.equivalentBranchAdmittanceMatrix(dl1, dl2);
        return adm.y12().negate().reciprocal().getReal() + 0.0;
    }

    public static double getX(DanglingLine dl1, DanglingLine dl2) {
        LinkData.BranchAdmittanceMatrix adm = TieLineUtil.equivalentBranchAdmittanceMatrix(dl1, dl2);
        return adm.y12().negate().reciprocal().getImaginary() + 0.0;
    }

    public static double getG1(DanglingLine dl1, DanglingLine dl2) {
        LinkData.BranchAdmittanceMatrix adm = TieLineUtil.equivalentBranchAdmittanceMatrix(dl1, dl2);
        return adm.y11().add(adm.y12()).getReal();
    }

    public static double getB1(DanglingLine dl1, DanglingLine dl2) {
        LinkData.BranchAdmittanceMatrix adm = TieLineUtil.equivalentBranchAdmittanceMatrix(dl1, dl2);
        return adm.y11().add(adm.y12()).getImaginary();
    }

    public static double getG2(DanglingLine dl1, DanglingLine dl2) {
        LinkData.BranchAdmittanceMatrix adm = TieLineUtil.equivalentBranchAdmittanceMatrix(dl1, dl2);
        return adm.y22().add(adm.y21()).getReal();
    }

    public static double getB2(DanglingLine dl1, DanglingLine dl2) {
        LinkData.BranchAdmittanceMatrix adm = TieLineUtil.equivalentBranchAdmittanceMatrix(dl1, dl2);
        return adm.y22().add(adm.y21()).getImaginary();
    }

    public static double getBoundaryV(DanglingLine dl1, DanglingLine dl2) {
        Complex boundaryV = TieLineUtil.voltageAtTheBoundaryNode(dl1, dl2);
        return boundaryV.abs();
    }

    public static double getBoundaryAngle(DanglingLine dl1, DanglingLine dl2) {
        Complex boundaryV = TieLineUtil.voltageAtTheBoundaryNode(dl1, dl2);
        return Math.toDegrees(Math.atan2(boundaryV.getImaginary(), boundaryV.getReal()));
    }

    private static LinkData.BranchAdmittanceMatrix equivalentBranchAdmittanceMatrix(DanglingLine dl1, DanglingLine dl2) {
        LinkData.BranchAdmittanceMatrix adm1 = LinkData.calculateBranchAdmittance(dl1.getR(), dl1.getX(), 1.0, 0.0, 1.0, 0.0, new Complex(dl1.getG(), dl1.getB()), new Complex(0.0, 0.0));
        LinkData.BranchAdmittanceMatrix adm2 = LinkData.calculateBranchAdmittance(dl2.getR(), dl2.getX(), 1.0, 0.0, 1.0, 0.0, new Complex(0.0, 0.0), new Complex(dl2.getG(), dl2.getB()));
        if (TieLineUtil.zeroImpedanceLine(adm1)) {
            return adm2;
        }
        if (TieLineUtil.zeroImpedanceLine(adm2)) {
            return adm1;
        }
        return LinkData.kronChain(adm1, TwoSides.TWO, adm2, TwoSides.ONE);
    }

    private static boolean zeroImpedanceLine(LinkData.BranchAdmittanceMatrix adm) {
        if (adm.y12().getReal() == 0.0 && adm.y12().getImaginary() == 0.0) {
            return true;
        }
        return adm.y21().getReal() == 0.0 && adm.y22().getImaginary() == 0.0;
    }

    private static Complex voltageAtTheBoundaryNode(DanglingLine dl1, DanglingLine dl2) {
        Complex v1 = ComplexUtils.polar2Complex((double)DanglingLineData.getV(dl1), (double)DanglingLineData.getTheta(dl1));
        Complex v2 = ComplexUtils.polar2Complex((double)DanglingLineData.getV(dl2), (double)DanglingLineData.getTheta(dl2));
        LinkData.BranchAdmittanceMatrix adm1 = LinkData.calculateBranchAdmittance(dl1.getR(), dl1.getX(), 1.0, 0.0, 1.0, 0.0, new Complex(dl1.getG(), dl1.getB()), new Complex(0.0, 0.0));
        LinkData.BranchAdmittanceMatrix adm2 = LinkData.calculateBranchAdmittance(dl2.getR(), dl2.getX(), 1.0, 0.0, 1.0, 0.0, new Complex(0.0, 0.0), new Complex(dl2.getG(), dl2.getB()));
        return adm1.y21().multiply(v1).add(adm2.y12().multiply(v2)).negate().divide(adm1.y22().add(adm2.y11()));
    }

    public static Optional<DanglingLine> getPairedDanglingLine(DanglingLine danglingLine) {
        return danglingLine.getTieLine().map(t -> t.getDanglingLine1() == danglingLine ? t.getDanglingLine2() : t.getDanglingLine1());
    }
}

