/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TwoSides;
import java.util.Collection;
import java.util.Optional;

public interface Branch<I extends Branch<I>>
extends Identifiable<I> {
    public Terminal getTerminal1();

    public Terminal getTerminal2();

    public Terminal getTerminal(TwoSides var1);

    public Terminal getTerminal(String var1);

    public TwoSides getSide(Terminal var1);

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups1();

    public Optional<String> getSelectedOperationalLimitsGroupId1();

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup1(String var1);

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup1();

    public OperationalLimitsGroup newOperationalLimitsGroup1(String var1);

    public void setSelectedOperationalLimitsGroup1(String var1);

    public void removeOperationalLimitsGroup1(String var1);

    public void cancelSelectedOperationalLimitsGroup1();

    default public Optional<CurrentLimits> getCurrentLimits1() {
        return this.getSelectedOperationalLimitsGroup1().flatMap(OperationalLimitsGroup::getCurrentLimits);
    }

    default public CurrentLimits getNullableCurrentLimits1() {
        return this.getCurrentLimits1().orElse(null);
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits1() {
        return this.getSelectedOperationalLimitsGroup1().flatMap(OperationalLimitsGroup::getActivePowerLimits);
    }

    default public ActivePowerLimits getNullableActivePowerLimits1() {
        return this.getActivePowerLimits1().orElse(null);
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits1() {
        return this.getSelectedOperationalLimitsGroup1().flatMap(OperationalLimitsGroup::getApparentPowerLimits);
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits1() {
        return this.getApparentPowerLimits1().orElse(null);
    }

    public CurrentLimitsAdder newCurrentLimits1();

    public ActivePowerLimitsAdder newActivePowerLimits1();

    public ApparentPowerLimitsAdder newApparentPowerLimits1();

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups2();

    public Optional<String> getSelectedOperationalLimitsGroupId2();

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup2(String var1);

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup2();

    public OperationalLimitsGroup newOperationalLimitsGroup2(String var1);

    public void setSelectedOperationalLimitsGroup2(String var1);

    public void removeOperationalLimitsGroup2(String var1);

    public void cancelSelectedOperationalLimitsGroup2();

    default public Optional<CurrentLimits> getCurrentLimits2() {
        return this.getSelectedOperationalLimitsGroup2().flatMap(OperationalLimitsGroup::getCurrentLimits);
    }

    default public CurrentLimits getNullableCurrentLimits2() {
        return this.getCurrentLimits2().orElse(null);
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits2() {
        return this.getSelectedOperationalLimitsGroup2().flatMap(OperationalLimitsGroup::getActivePowerLimits);
    }

    default public ActivePowerLimits getNullableActivePowerLimits2() {
        return this.getActivePowerLimits2().orElse(null);
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits2() {
        return this.getSelectedOperationalLimitsGroup2().flatMap(OperationalLimitsGroup::getApparentPowerLimits);
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits2() {
        return this.getApparentPowerLimits2().orElse(null);
    }

    public CurrentLimitsAdder newCurrentLimits2();

    public ActivePowerLimitsAdder newActivePowerLimits2();

    public ApparentPowerLimitsAdder newApparentPowerLimits2();

    default public Optional<CurrentLimits> getCurrentLimits(TwoSides side) {
        switch (side) {
            case ONE: {
                return this.getCurrentLimits1();
            }
            case TWO: {
                return this.getCurrentLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public Optional<ActivePowerLimits> getActivePowerLimits(TwoSides side) {
        switch (side) {
            case ONE: {
                return this.getActivePowerLimits1();
            }
            case TWO: {
                return this.getActivePowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public Optional<ApparentPowerLimits> getApparentPowerLimits(TwoSides side) {
        switch (side) {
            case ONE: {
                return this.getApparentPowerLimits1();
            }
            case TWO: {
                return this.getApparentPowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public Optional<? extends LoadingLimits> getLimits(LimitType type, TwoSides side) {
        switch (type) {
            case CURRENT: {
                return this.getCurrentLimits(side);
            }
            case ACTIVE_POWER: {
                return this.getActivePowerLimits(side);
            }
            case APPARENT_POWER: {
                return this.getApparentPowerLimits(side);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    default public CurrentLimits getNullableCurrentLimits(TwoSides side) {
        switch (side) {
            case ONE: {
                return this.getNullableCurrentLimits1();
            }
            case TWO: {
                return this.getNullableCurrentLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public ActivePowerLimits getNullableActivePowerLimits(TwoSides side) {
        switch (side) {
            case ONE: {
                return this.getNullableActivePowerLimits1();
            }
            case TWO: {
                return this.getNullableActivePowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public ApparentPowerLimits getNullableApparentPowerLimits(TwoSides side) {
        switch (side) {
            case ONE: {
                return this.getNullableApparentPowerLimits1();
            }
            case TWO: {
                return this.getNullableApparentPowerLimits2();
            }
        }
        throw new UnsupportedOperationException(String.format("Side %s not supported", side.name()));
    }

    default public LoadingLimits getNullableLimits(LimitType type, TwoSides side) {
        switch (type) {
            case CURRENT: {
                return this.getNullableCurrentLimits(side);
            }
            case ACTIVE_POWER: {
                return this.getNullableActivePowerLimits(side);
            }
            case APPARENT_POWER: {
                return this.getNullableApparentPowerLimits(side);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    public boolean isOverloaded();

    public boolean isOverloaded(double var1);

    public int getOverloadDuration();

    public boolean checkPermanentLimit(TwoSides var1, double var2, LimitType var4);

    public boolean checkPermanentLimit(TwoSides var1, LimitType var2);

    public boolean checkPermanentLimit1(double var1, LimitType var3);

    public boolean checkPermanentLimit1(LimitType var1);

    public boolean checkPermanentLimit2(double var1, LimitType var3);

    public boolean checkPermanentLimit2(LimitType var1);

    public Overload checkTemporaryLimits(TwoSides var1, double var2, LimitType var4);

    public Overload checkTemporaryLimits(TwoSides var1, LimitType var2);

    public Overload checkTemporaryLimits1(double var1, LimitType var3);

    public Overload checkTemporaryLimits1(LimitType var1);

    public Overload checkTemporaryLimits2(double var1, LimitType var3);

    public Overload checkTemporaryLimits2(LimitType var1);
}

