/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.components;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Network;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

abstract class AbstractComponent
implements Component {
    private final int num;
    private final int size;

    protected AbstractComponent(int num, int size) {
        this.num = num;
        this.size = size;
    }

    @Override
    public int getNum() {
        return this.num;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Iterable<Bus> getBuses() {
        return StreamSupport.stream(this.getNetwork().getBusView().getBuses().spliterator(), false).filter(this.getBusPredicate()).collect(Collectors.toList());
    }

    @Override
    public Stream<Bus> getBusStream() {
        return this.getNetwork().getBusView().getBusStream().filter(this.getBusPredicate());
    }

    protected abstract Network getNetwork();

    protected abstract Predicate<Bus> getBusPredicate();
}

