/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.components;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.math.graph.GraphUtil;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractComponentsManager<C extends Component> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponentsManager.class);
    private final String label;
    private List<C> components;

    protected AbstractComponentsManager(String label) {
        this.label = Objects.requireNonNull(label);
    }

    public void invalidate() {
        this.components = null;
    }

    public void update() {
        int i;
        if (this.components != null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        for (Bus bus : this.getNetwork().getBusBreakerView().getBuses()) {
            this.setComponentNumber(bus, -1);
        }
        int num = 0;
        HashMap<String, Integer> id2num = new HashMap<String, Integer>();
        ArrayList<Bus> num2bus = new ArrayList<Bus>();
        for (Bus bus : this.getNetwork().getBusView().getBuses()) {
            num2bus.add(bus);
            id2num.put(bus.getId(), num);
            ++num;
        }
        TIntArrayList[] adjacencyList = new TIntArrayList[num];
        for (int i2 = 0; i2 < adjacencyList.length; ++i2) {
            adjacencyList[i2] = new TIntArrayList(3);
        }
        this.fillAdjacencyList(id2num, adjacencyList);
        GraphUtil.ConnectedComponentsComputationResult result = GraphUtil.computeConnectedComponents((TIntArrayList[])adjacencyList);
        this.components = new ArrayList<C>(result.getComponentSize().length);
        for (i = 0; i < result.getComponentSize().length; ++i) {
            this.components.add(this.createComponent(i, result.getComponentSize()[i]));
        }
        for (i = 0; i < result.getComponentNumber().length; ++i) {
            Bus bus = (Bus)num2bus.get(i);
            this.setComponentNumber(bus, result.getComponentNumber()[i]);
        }
        LOGGER.debug("{} components computed in {} ms", (Object)this.getComponentLabel(), (Object)(System.currentTimeMillis() - startTime));
    }

    public List<C> getConnectedComponents() {
        this.update();
        return this.components;
    }

    public C getComponent(int num) {
        return (C)(num != -1 ? (Component)this.components.get(num) : null);
    }

    void addToAdjacencyList(Bus bus1, Bus bus2, Map<String, Integer> id2num, TIntArrayList[] adjacencyList) {
        if (bus1 != null && bus2 != null) {
            int busNum1 = id2num.get(bus1.getId());
            int busNum2 = id2num.get(bus2.getId());
            adjacencyList[busNum1].add(busNum2);
            adjacencyList[busNum2].add(busNum1);
        }
    }

    protected void fillAdjacencyList(Map<String, Integer> id2num, TIntArrayList[] adjacencyList) {
        Bus bus2;
        Bus bus1;
        for (Line line : this.getNetwork().getLines()) {
            bus1 = line.getTerminal1().getBusView().getBus();
            bus2 = line.getTerminal2().getBusView().getBus();
            this.addToAdjacencyList(bus1, bus2, id2num, adjacencyList);
        }
        for (TieLine tieLine : this.getNetwork().getTieLines()) {
            bus1 = tieLine.getDanglingLine1().getTerminal().getBusView().getBus();
            bus2 = tieLine.getDanglingLine2().getTerminal().getBusView().getBus();
            this.addToAdjacencyList(bus1, bus2, id2num, adjacencyList);
        }
        for (TwoWindingsTransformer twoWindingsTransformer : this.getNetwork().getTwoWindingsTransformers()) {
            bus1 = twoWindingsTransformer.getTerminal1().getBusView().getBus();
            bus2 = twoWindingsTransformer.getTerminal2().getBusView().getBus();
            this.addToAdjacencyList(bus1, bus2, id2num, adjacencyList);
        }
        for (ThreeWindingsTransformer threeWindingsTransformer : this.getNetwork().getThreeWindingsTransformers()) {
            bus1 = threeWindingsTransformer.getLeg1().getTerminal().getBusView().getBus();
            bus2 = threeWindingsTransformer.getLeg2().getTerminal().getBusView().getBus();
            Bus bus3 = threeWindingsTransformer.getLeg3().getTerminal().getBusView().getBus();
            this.addToAdjacencyList(bus1, bus2, id2num, adjacencyList);
            this.addToAdjacencyList(bus1, bus3, id2num, adjacencyList);
            this.addToAdjacencyList(bus2, bus3, id2num, adjacencyList);
        }
    }

    private String getComponentLabel() {
        return this.label;
    }

    protected abstract Network getNetwork();

    protected abstract C createComponent(int var1, int var2);

    protected abstract void setComponentNumber(Bus var1, int var2);
}

